/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.server.provisioning.lancom;

import at.mrdevelopment.esl.configuration.Config;
import at.mrdevelopment.esl.server.provisioning.ModuleSpecificSettings;
import at.mrdevelopment.esl.server.provisioning.field.ConfigField;
import at.mrdevelopment.esl.server.provisioning.lancom.ReinitConfigHolder;
import at.mrdevelopment.esl.server.provisioning.lancom.ReinitFields;
import java.util.Collections;

public class LancomModuleSettings
implements ModuleSpecificSettings {
    private final ReinitConfigHolder reinitSettings = new ReinitConfigHolder(Config.getLancomUseTcpThinMode());
    private boolean reinitSettingsChanged;
    private final long discoveryIntervalInMilliseconds = (long)Config.getLancomDiscoveryIntervalInSeconds() * 1000L;
    private final int discoveryDurationInSeconds = Config.getLancomDiscoveryDurationInSeconds();
    private final int maxTimeouts = Config.getLancomMaxTimeouts();
    private final int readTimeoutInMilliseconds = Config.getLancomReadTimeoutInMilliseconds();
    private final String defaultUsername;
    private final String defaultPassword;
    private final String username = Config.getLancomUsername();
    private final String password = Config.getLancomPassword();
    private boolean changed;
    private boolean isDiscoveryEnabled = Config.getLancomDiscoveryEnabled();

    public LancomModuleSettings() {
        this.defaultUsername = "root";
        this.defaultPassword = "";
    }

    public long getDiscoveryIntervalInMilliseconds() {
        return this.discoveryIntervalInMilliseconds;
    }

    public int getDiscoveryDurationInSeconds() {
        return this.discoveryDurationInSeconds;
    }

    public int getMaxTimeouts() {
        return this.maxTimeouts;
    }

    public int getReadTimeoutInMilliseconds() {
        return this.readTimeoutInMilliseconds;
    }

    public String getUsername() {
        return this.username != null ? this.username : "";
    }

    public String getPassword() {
        return this.password != null ? this.password : "";
    }

    public String getDefaultUsername() {
        return this.defaultUsername;
    }

    public String getDefaultPassword() {
        return this.defaultPassword;
    }

    public boolean usernameIsDefault() {
        return this.defaultUsername.equals(this.username);
    }

    @Override
    public void calculateDifferences(ModuleSpecificSettings other) {
        if (other != null) {
            LancomModuleSettings lms = (LancomModuleSettings)other;
            this.changed = !lms.getPassword().equals(this.password) || !lms.getUsername().equals(this.username);
            this.reinitSettingsChanged = this.reinitSettings.isDifferentFrom(lms.reinitSettings, Collections.<ConfigField>emptyList());
        } else {
            this.changed = true;
            this.reinitSettingsChanged = false;
        }
    }

    @Override
    public boolean connectionSettingsChanged() {
        return this.changed;
    }

    @Override
    public boolean commonSettingsChanged() {
        return false;
    }

    @Override
    public boolean isDiscoveryEnabled() {
        return this.isDiscoveryEnabled;
    }

    @Override
    public boolean accessPointsRequireReinit() {
        return this.reinitSettingsChanged;
    }

    @Override
    public boolean thinModeEnabled() {
        return this.reinitSettings.get(ReinitFields.USE_TCP_THIN_MODE).getBoolValue();
    }
}

