/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.server.provisioning.lancom;

import at.mrdevelopment.esl.accesspoint.AccessPointService;
import at.mrdevelopment.esl.accesspoint.ThinAccessPointService;
import at.mrdevelopment.esl.core.ServiceAddress;
import at.mrdevelopment.esl.core.accesspoint.AccessPointType;
import at.mrdevelopment.esl.persistence.DatasetException;
import at.mrdevelopment.esl.persistence.dataset.AccessPointInfoDataset;
import at.mrdevelopment.esl.persistence.dataset.NoTransaction;
import at.mrdevelopment.esl.persistence.dataset.Transaction;
import at.mrdevelopment.esl.persistence.record.AccessPointInfo;
import at.mrdevelopment.esl.server.provisioning.ModuleSpecificSettings;
import at.mrdevelopment.esl.server.provisioning.discovery.DiscoveryMode;
import at.mrdevelopment.esl.server.provisioning.discovery.DiscoveryModule;
import at.mrdevelopment.esl.server.provisioning.discovery.SearchResult;
import at.mrdevelopment.esl.server.provisioning.field.BaseExtConfigHolder;
import at.mrdevelopment.esl.server.provisioning.field.BasicFields;
import at.mrdevelopment.esl.server.provisioning.lancom.ConfigTranslator;
import at.mrdevelopment.esl.server.provisioning.lancom.LancomConfigHolder;
import at.mrdevelopment.esl.server.provisioning.lancom.LancomDiscoverer;
import at.mrdevelopment.esl.server.provisioning.lancom.LancomFields;
import at.mrdevelopment.esl.server.provisioning.lancom.LancomModuleSettings;
import at.mrdevelopment.esl.server.provisioning.message.AccessPointProvisioningQueries;
import at.mrdevelopment.toolkit.Version;
import at.mrdevelopment.toolkit.lancom.ConnectResult;
import at.mrdevelopment.toolkit.lancom.LancomConfigOption;
import at.mrdevelopment.toolkit.lancom.LancomConfiguration;
import at.mrdevelopment.toolkit.lancom.LancomInfo;
import at.mrdevelopment.toolkit.log.ESLLogger;
import com.sshtools.ssh.SshException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.lang.StringUtils;

public class LancomDiscoveryModule
implements DiscoveryModule {
    private static ESLLogger logger = ESLLogger.getLogger(LancomDiscoveryModule.class);
    private final AccessPointProvisioningQueries apProvQueries;
    private final AccessPointInfoDataset infoDataset;
    private final LinkedList<AccessPointInfo> discoveredAPs = new LinkedList();
    private boolean discoveryEnabled;
    private final Lock lock = new ReentrantLock();
    private LancomDiscoverer discoverer;
    private LancomModuleSettings settings;
    private boolean shutdownRequested;

    public LancomDiscoveryModule(AccessPointProvisioningQueries apProvQueries, AccessPointInfoDataset infoDataset) {
        this.apProvQueries = apProvQueries;
        this.infoDataset = infoDataset;
        this.shutdownRequested = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SearchResult search() {
        SearchResult result = new SearchResult();
        List<LancomConfiguration> lancomConfigs = null;
        this.lock.lock();
        try {
            if (this.discoverer != null) {
                lancomConfigs = this.discoverer.getResults();
            }
        }
        finally {
            this.lock.unlock();
        }
        if (lancomConfigs == null) {
            return result;
        }
        this.apProvQueries.clearDiscoveryRelated();
        LinkedList<AccessPointInfo> linkedList = this.discoveredAPs;
        synchronized (linkedList) {
            this.discoveredAPs.clear();
            for (LancomConfiguration lancomConfig : lancomConfigs) {
                if (!StringUtils.isNotBlank((String)lancomConfig.getApId())) continue;
                LancomConfigHolder lch = ConfigTranslator.fromLancomToCommon(lancomConfig);
                String authenticationResult = lancomConfig.get(LancomConfigOption.AUTHENTICATION_RESULT);
                if (lch.isIncomplete() && authenticationResult != null && !authenticationResult.isEmpty()) {
                    this.apProvQueries.discoveryIncompleteFor(lch.getBasicConfig().getApId());
                    ConnectResult res = ConnectResult.valueOf((String)authenticationResult);
                    if (res == ConnectResult.CONNECT_ERROR) {
                        this.apProvQueries.apNotAvailable(lch.getBasicConfig().getApId());
                    } else if (res == ConnectResult.AUTHENTICATION_ERROR) {
                        this.apProvQueries.authenticationFailed(lch.getBasicConfig().getApId());
                    }
                }
                ServiceAddress servAddress = lch.isUdpPortSet() ? new ServiceAddress(false, lch.getBasicConfig().getAddress(), lch.getUdpPort()) : new ServiceAddress(false, lch.getBasicConfig().getAddress(), AccessPointType.LANCOM.getDefaultPort());
                ServiceAddress managementAddress = new ServiceAddress(false, lch.getBasicConfig().getAddress(), 80);
                AccessPointInfo newInfo = AccessPointInfo.createDiscovered((int)lch.getBasicConfig().getApId(), (ServiceAddress)servAddress, (ServiceAddress)managementAddress, (Version)Version.UNDEFINED, null);
                newInfo.setName(lch.getBasicConfig().getAddress());
                newInfo.setSerial(lch.getSerialNumber());
                newInfo.setTypeIdentifier(lancomConfig.getDevice());
                try {
                    newInfo.setVersion(Version.fromLancomVersion((String)lancomConfig.getFirmwareVersion()));
                }
                catch (IllegalArgumentException exc) {
                    logger.warn("Could not parse Lancom version for input %s: %s", new Object[]{lancomConfig.getFirmwareVersion(), exc.getMessage()});
                    logger.logExceptionIfDebugEnabled((Throwable)exc);
                }
                if (lch.isSet(LancomFields.CONTROLLER_IP)) {
                    newInfo.setServer(lch.getControllerAddress());
                }
                if (lch.getBasicConfig().isSet(BasicFields.WIRELESS_CHANNEL)) {
                    newInfo.setChannel(lch.getBasicConfig().getWirelessChannel());
                }
                this.updateConfiguredLancomInfo(newInfo);
                this.discoveredAPs.add(newInfo);
                result.add(lch);
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Discovered LANCOM data:");
                for (BaseExtConfigHolder configHolder : result.foundAccessPoints()) {
                    logger.debug(configHolder.toString());
                }
            }
        }
        return result;
    }

    private void updateConfiguredLancomInfo(AccessPointInfo newInfo) {
        AccessPointService accessPointService = this.infoDataset.getService(newInfo.getAccessPointId());
        if (accessPointService != null && accessPointService instanceof ThinAccessPointService) {
            ((ThinAccessPointService)accessPointService).notifyLancomInformation(new LancomInfo(newInfo.getAccessPointId(), newInfo.getSerial(), newInfo.getTypeIdentifier(), newInfo.getVersion()));
        }
        try {
            AccessPointInfo accessPointInfo = this.infoDataset.queryById((long)newInfo.getAccessPointId().intValue(), (Transaction<?>)NoTransaction.get());
            if (accessPointInfo != null && !accessPointInfo.isDiscovered()) {
                accessPointInfo.setTypeIdentifier(newInfo.getTypeIdentifier());
                accessPointInfo.setSerial(newInfo.getSerial());
                accessPointInfo.setVersion(newInfo.getVersion());
                accessPointInfo.setName(newInfo.getName());
            }
        }
        catch (DatasetException exc) {
            logger.warn("Could not update Lancom AP type: %s", new Object[]{exc.getMessage()});
            logger.logExceptionIfDebugEnabled((Throwable)exc);
        }
    }

    @Override
    public boolean isRunning() {
        return this.discoverer != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<AccessPointInfo> getDiscoveredAccessPoints() {
        List<Object> result;
        if (this.discoveryEnabled) {
            LinkedList<AccessPointInfo> linkedList = this.discoveredAPs;
            synchronized (linkedList) {
                result = new ArrayList<AccessPointInfo>(this.discoveredAPs);
            }
        }
        LinkedList<AccessPointInfo> linkedList = this.discoveredAPs;
        synchronized (linkedList) {
            if (!this.discoveredAPs.isEmpty()) {
                this.discoveredAPs.clear();
            }
        }
        result = Collections.emptyList();
        return result;
    }

    @Override
    public void init(boolean sslEnabled, boolean discoveryEnabled) {
        this.discoveryEnabled = discoveryEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void receive(ModuleSpecificSettings newSettings) {
        if (newSettings instanceof LancomModuleSettings) {
            this.settings = (LancomModuleSettings)newSettings;
            this.lock.lock();
            try {
                if (this.discoverer != null) {
                    this.discoverer.setSettings(this.settings);
                }
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        this.lock.lock();
        try {
            if (!this.shutdownRequested) {
                try {
                    this.discoverer = new LancomDiscoverer(this.settings, this.infoDataset.getConfiguredAndLicensedAccessPointManager());
                    Thread thread = new Thread(this.discoverer);
                    thread.setName("LancomDiscoverer");
                    thread.start();
                }
                catch (SshException exc) {
                    logger.error("Could not start lancom discovery thread: %s", new Object[]{exc.getMessage()});
                    logger.logException((Throwable)exc);
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        this.lock.lock();
        try {
            if (this.discoverer != null) {
                this.discoverer.stop();
                this.discoverer = null;
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        this.lock.lock();
        try {
            this.shutdownRequested = true;
            this.stop();
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public DiscoveryMode getMode() {
        return DiscoveryMode.WORK_IN_BACKGROUND;
    }
}

