/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.server.provisioning.lancom;

import at.mrdevelopment.esl.accesspoint.AccessPointService;
import at.mrdevelopment.esl.accesspoint.AccessPointServiceManager;
import at.mrdevelopment.esl.server.provisioning.lancom.LancomModuleSettings;
import at.mrdevelopment.toolkit.lancom.LancomConfiguration;
import at.mrdevelopment.toolkit.lancom.LancomDiscoveryClient;
import at.mrdevelopment.toolkit.log.ESLLogger;
import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.sshtools.ssh.SshException;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;

public class LancomDiscoverer
implements Runnable {
    private static ESLLogger logger = ESLLogger.getLogger(LancomDiscoverer.class);
    private volatile boolean shutdownRequested = false;
    private volatile LancomModuleSettings settings;
    private final LancomDiscoveryClient client;
    private final AtomicReference<List<LancomConfiguration>> resultRef;
    private final AccessPointServiceManager licensedAccessPoints;

    public LancomDiscoverer(LancomModuleSettings settings, AccessPointServiceManager licensedAccessPoints) throws SshException {
        this.licensedAccessPoints = licensedAccessPoints;
        this.client = new LancomDiscoveryClient();
        this.resultRef = new AtomicReference<Object>(null);
        this.settings = settings;
    }

    List<LancomConfiguration> getResults() {
        return this.resultRef.getAndSet(null);
    }

    public void setSettings(LancomModuleSettings settings) {
        this.settings = settings;
    }

    @Override
    public void run() {
        long lastDiscoveryTime = 0L;
        while (!this.shutdownRequested) {
            long currentTime = System.currentTimeMillis();
            LancomModuleSettings currentSettings = this.settings;
            if (currentSettings != null && currentTime - lastDiscoveryTime >= currentSettings.getDiscoveryIntervalInMilliseconds()) {
                logger.info("Started lancom discovery.");
                try {
                    lastDiscoveryTime = currentTime;
                    this.client.setDuration(currentSettings.getDiscoveryDurationInSeconds());
                    this.client.setMaxTimeouts(currentSettings.getMaxTimeouts());
                    this.client.setTimeout(currentSettings.getReadTimeoutInMilliseconds());
                    this.client.setCredentials(currentSettings.getUsername(), currentSettings.getPassword());
                    this.resultRef.set(this.client.search(Collections2.transform(this.licensedAccessPoints.getAccessPoints(), (Function)new Function<AccessPointService, Integer>(){

                        public Integer apply(AccessPointService accessPointService) {
                            return accessPointService.getAccessPointId();
                        }
                    })));
                }
                catch (IOException ioe) {
                    logger.logException((Throwable)ioe);
                }
                logger.info("Finished lancom discovery.");
            }
            try {
                if (this.shutdownRequested) continue;
                Thread.sleep(2000L);
            }
            catch (InterruptedException e) {}
        }
    }

    public boolean isRunning() {
        return !this.shutdownRequested;
    }

    public void stop() {
        this.shutdownRequested = true;
        this.client.shutdown();
    }
}

