/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.server.provisioning.lancom;

import at.mrdevelopment.esl.server.provisioning.field.BaseExtConfigHolder;
import at.mrdevelopment.esl.server.provisioning.field.BasicFields;
import at.mrdevelopment.esl.server.provisioning.field.ConfigField;
import at.mrdevelopment.esl.server.provisioning.field.ConfigFieldValue;
import at.mrdevelopment.esl.server.provisioning.field.Difference;
import at.mrdevelopment.esl.server.provisioning.lancom.LancomFields;
import java.util.Collection;
import java.util.Collections;

public class LancomConfigHolder
extends BaseExtConfigHolder {
    public static final Collection<ConfigField> FIELDS_TO_IGNORE = Collections.singletonList(BasicFields.HOSTNAME);

    public LancomConfigHolder(long discoveryTimeInMillis) {
        super(LancomFields.FIELDS, discoveryTimeInMillis);
    }

    public boolean isUdpPortSet() {
        return this.basicConfig.isSet(BasicFields.PORT);
    }

    public int getUdpPort() {
        ConfigFieldValue cfv = this.basicConfig.get(BasicFields.PORT);
        return cfv.getIntValue();
    }

    public String getSerialNumber() {
        ConfigFieldValue cfv = this.get(LancomFields.SERIAL_NUMBER);
        return cfv.getStringValue();
    }

    public void setSerialNumber(String number) {
        this.set(LancomFields.SERIAL_NUMBER, number);
    }

    public String getControllerAddress() {
        ConfigFieldValue cfv = this.get(LancomFields.CONTROLLER_IP);
        return cfv.getStringValue();
    }

    public void setControllerAddress(String address) {
        this.set(LancomFields.CONTROLLER_IP, address);
    }

    public boolean isIncomplete() {
        return !this.isSet(LancomFields.WE_PAPER_MODULE_OPERATING);
    }

    public boolean isOperating() {
        return this.isSet(LancomFields.WE_PAPER_MODULE_OPERATING) && this.get(LancomFields.WE_PAPER_MODULE_OPERATING).getBoolValue();
    }

    public boolean wasAuthenticationSuccessful() {
        return this.isSet(LancomFields.AUTHENTICATION_SUCCESSFUL) && this.get(LancomFields.AUTHENTICATION_SUCCESSFUL).getBoolValue();
    }

    @Override
    public BaseExtConfigHolder copy() {
        LancomConfigHolder config = new LancomConfigHolder(this.discoveryTimeInMillis);
        config.transferFrom(this);
        return config;
    }

    @Override
    public void customOvertake(BaseExtConfigHolder from) {
        this.overtake(from, FIELDS_TO_IGNORE);
    }

    @Override
    public Difference isDifferentFrom(BaseExtConfigHolder other) {
        return super.isDifferentFrom(other, FIELDS_TO_IGNORE);
    }
}

