/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.server.provisioning.imagotag;

import at.mrdevelopment.esl.admin.platform.EnvironmentProperties;
import at.mrdevelopment.esl.core.ServiceAddress;
import at.mrdevelopment.esl.core.accesspoint.AccessPointType;
import at.mrdevelopment.esl.persistence.dataset.AccessPointInfoDataset;
import at.mrdevelopment.esl.server.provisioning.ModuleSpecificSettings;
import at.mrdevelopment.esl.server.provisioning.field.BaseExtConfigHolder;
import at.mrdevelopment.esl.server.provisioning.field.BasicConfigHolder;
import at.mrdevelopment.esl.server.provisioning.field.BasicFields;
import at.mrdevelopment.esl.server.provisioning.imagotag.ImagotagConfigHolder;
import at.mrdevelopment.esl.server.provisioning.service.ServiceModule;
import at.mrdevelopment.esl.server.provisioning.situation.AccessPointConfigSituation;

public class ImagotagServiceModule
implements ServiceModule {
    private boolean sslEnabled = false;

    @Override
    public void makeAccessPointServiceGoOffline(AccessPointConfigSituation situation, AccessPointInfoDataset infoDataset, EnvironmentProperties env) {
        infoDataset.removeAccessPointService(situation.getApId());
        ServiceAddress newAddress = situation.createServiceAddress(env);
        infoDataset.updateOfflineAccessPointAddress(situation.getApId(), newAddress, situation.canUpdate(), situation.isThinModeEnabled());
    }

    @Override
    public ServiceAddress createServiceAddress(BaseExtConfigHolder configHolder) {
        ImagotagConfigHolder imagoConfigHolder = (ImagotagConfigHolder)configHolder;
        ServiceAddress address = new ServiceAddress(this.sslEnabled, imagoConfigHolder.getBasicConfig().getAddress(), imagoConfigHolder.getBasicConfig().getPort());
        return address;
    }

    @Override
    public ServiceAddress createServiceAddress(BasicConfigHolder configHolder) {
        ServiceAddress address = new ServiceAddress(this.sslEnabled, configHolder.getAddress(), configHolder.isSet(BasicFields.PORT) ? configHolder.getPort() : AccessPointType.IMAGOTAG.getDefaultPort());
        return address;
    }

    @Override
    public ServiceAddress createDummyServiceAddress(EnvironmentProperties env) {
        return new ServiceAddress(this.sslEnabled, "", AccessPointType.IMAGOTAG.getDefaultPort());
    }

    @Override
    public void init(boolean sslEnabled) {
        this.sslEnabled = sslEnabled;
    }

    @Override
    public void receive(ModuleSpecificSettings settings) {
    }
}

