/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.server.provisioning.imagotag;

import at.mrdevelopment.esl.core.accesspoint.AccessPointType;
import at.mrdevelopment.esl.custom.ServerStartupSettings;
import at.mrdevelopment.esl.persistence.dataset.AccessPointInfoDataset;
import at.mrdevelopment.esl.server.AutoConfigurationBroadcastProcessor;
import at.mrdevelopment.esl.server.DiscoveredAccessPointsHolder;
import at.mrdevelopment.esl.server.provisioning.AccessPointModulesProvider;
import at.mrdevelopment.esl.server.provisioning.SettingsCreator;
import at.mrdevelopment.esl.server.provisioning.configuration.ConfigurationModule;
import at.mrdevelopment.esl.server.provisioning.decisionlogic.DecisionLogicModule;
import at.mrdevelopment.esl.server.provisioning.discovery.DiscoveryModule;
import at.mrdevelopment.esl.server.provisioning.imagotag.ImagotagConfigurationModule;
import at.mrdevelopment.esl.server.provisioning.imagotag.ImagotagDecisionLogicModule;
import at.mrdevelopment.esl.server.provisioning.imagotag.ImagotagDiscoveryModule;
import at.mrdevelopment.esl.server.provisioning.imagotag.ImagotagServiceModule;
import at.mrdevelopment.esl.server.provisioning.imagotag.ImagotagSettingsCreator;
import at.mrdevelopment.esl.server.provisioning.imagotag.ImagotagSoftwareUpdateModule;
import at.mrdevelopment.esl.server.provisioning.service.ServiceModule;
import at.mrdevelopment.esl.server.provisioning.softwareupdate.SoftwareUpdateModule;

public class ImagotagModulesProvider
implements AccessPointModulesProvider {
    private final ImagotagConfigurationModule configurationModule = new ImagotagConfigurationModule();
    private final ImagotagDiscoveryModule discoveryModule;
    private final ImagotagDecisionLogicModule decisionLogicModule;
    private final ImagotagServiceModule serviceModule;
    private final ImagotagSettingsCreator settingsCreator;
    private final ImagotagSoftwareUpdateModule softwareUpdateModule;

    public ImagotagModulesProvider(AccessPointInfoDataset infoDataset, AutoConfigurationBroadcastProcessor broadcastProcessor, DiscoveredAccessPointsHolder discoveredImagoAPs, ServerStartupSettings serverStartupSettings) {
        this.discoveryModule = new ImagotagDiscoveryModule(broadcastProcessor, discoveredImagoAPs, serverStartupSettings);
        this.decisionLogicModule = new ImagotagDecisionLogicModule();
        this.serviceModule = new ImagotagServiceModule();
        this.settingsCreator = new ImagotagSettingsCreator();
        this.softwareUpdateModule = new ImagotagSoftwareUpdateModule(infoDataset);
    }

    @Override
    public DiscoveryModule getDiscoveryModule() {
        return this.discoveryModule;
    }

    @Override
    public ConfigurationModule getConfigurationModule() {
        return this.configurationModule;
    }

    @Override
    public DecisionLogicModule getDecisioLogicModule() {
        return this.decisionLogicModule;
    }

    @Override
    public ServiceModule getServiceModule() {
        return this.serviceModule;
    }

    @Override
    public AccessPointType getAccessPointType() {
        return AccessPointType.IMAGOTAG;
    }

    @Override
    public SettingsCreator getSettingsCreator() {
        return this.settingsCreator;
    }

    @Override
    public SoftwareUpdateModule getSoftwareUpdateModule() {
        return this.softwareUpdateModule;
    }
}

