/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.server.provisioning.imagotag;

import at.mrdevelopment.esl.admin.platform.EnvironmentProperties;
import at.mrdevelopment.esl.configuration.Config;
import at.mrdevelopment.esl.server.provisioning.ModuleSpecificSettings;
import at.mrdevelopment.esl.server.provisioning.field.ConfigField;
import at.mrdevelopment.esl.server.provisioning.imagotag.CommonConfigHolder;
import at.mrdevelopment.esl.server.provisioning.imagotag.ReinitConfigHolder;
import at.mrdevelopment.esl.server.provisioning.imagotag.ReinitFields;
import java.util.Collections;

public class ImagotagModuleSettings
implements ModuleSpecificSettings {
    private final CommonConfigHolder serverSettings;
    private final ReinitConfigHolder reinitSettings;
    private boolean commonSettingsChanged;
    private boolean reinitSettingsChanged;
    private boolean isDiscoveryEnabled;

    public ImagotagModuleSettings(EnvironmentProperties env) {
        boolean thinModeEnabled = Config.isAccessPointUseThinMode();
        this.serverSettings = new CommonConfigHolder(env, thinModeEnabled);
        this.reinitSettings = new ReinitConfigHolder(thinModeEnabled);
        this.commonSettingsChanged = false;
        this.reinitSettingsChanged = false;
        this.isDiscoveryEnabled = Config.isListenForAccessPointBroadcastEnabled();
    }

    @Override
    public void calculateDifferences(ModuleSpecificSettings other) {
        if (other != null) {
            ImagotagModuleSettings temp = (ImagotagModuleSettings)other;
            this.commonSettingsChanged = this.serverSettings.isDifferentFrom(temp.serverSettings, Collections.<ConfigField>emptyList());
            this.reinitSettingsChanged = this.reinitSettings.isDifferentFrom(temp.reinitSettings, Collections.<ConfigField>emptyList());
        } else {
            this.commonSettingsChanged = true;
            this.reinitSettingsChanged = false;
        }
    }

    @Override
    public boolean connectionSettingsChanged() {
        return false;
    }

    @Override
    public boolean commonSettingsChanged() {
        return this.commonSettingsChanged;
    }

    @Override
    public boolean isDiscoveryEnabled() {
        return this.isDiscoveryEnabled;
    }

    public CommonConfigHolder getServerSettings() {
        return this.serverSettings;
    }

    @Override
    public boolean accessPointsRequireReinit() {
        return this.reinitSettingsChanged;
    }

    @Override
    public boolean thinModeEnabled() {
        return this.reinitSettings.get(ReinitFields.USE_THIN_MODE).getBoolValue();
    }
}

