/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.server.provisioning.imagotag;

import at.mrdevelopment.esl.configuration.Config;
import at.mrdevelopment.esl.core.ServiceAddress;
import at.mrdevelopment.esl.core.accesspoint.AccessPointType;
import at.mrdevelopment.esl.core.accesspoint.AccessPointTypeMapping;
import at.mrdevelopment.esl.custom.ServerStartupSettings;
import at.mrdevelopment.esl.persistence.record.AccessPointInfo;
import at.mrdevelopment.esl.processing.BroadcastListener;
import at.mrdevelopment.esl.processing.BroadcastProcessor;
import at.mrdevelopment.esl.server.AutoConfigurationBroadcastProcessor;
import at.mrdevelopment.esl.server.DiscoveredAccessPointsHolder;
import at.mrdevelopment.esl.server.provisioning.ModuleSpecificSettings;
import at.mrdevelopment.esl.server.provisioning.discovery.DiscoveryMode;
import at.mrdevelopment.esl.server.provisioning.discovery.DiscoveryModule;
import at.mrdevelopment.esl.server.provisioning.discovery.SearchResult;
import at.mrdevelopment.esl.server.provisioning.imagotag.ImagotagConfigHolder;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.log.ESLLogger;
import java.net.MalformedURLException;
import java.util.List;

public class ImagotagDiscoveryModule
implements DiscoveryModule {
    private static final ESLLogger logger = ESLLogger.getLogger(ImagotagDiscoveryModule.class);
    private BroadcastListener listener;
    private AutoConfigurationBroadcastProcessor processor;
    private final ServerStartupSettings serverStartupSettings;
    private final DiscoveredAccessPointsHolder imagoAPs;

    ImagotagDiscoveryModule(AutoConfigurationBroadcastProcessor processor, DiscoveredAccessPointsHolder discoveredImagoAPs, ServerStartupSettings serverStartupSettings) {
        this.processor = processor;
        this.imagoAPs = discoveredImagoAPs;
        this.serverStartupSettings = serverStartupSettings;
    }

    public void shutdown() {
        this.stop();
    }

    @Override
    public DiscoveryMode getMode() {
        return DiscoveryMode.WORK_IN_BACKGROUND;
    }

    @Override
    public void start() {
        int port = Config.getBroadcastPort();
        try {
            this.listener = new BroadcastListener((BroadcastProcessor)this.processor, port, this.serverStartupSettings != null ? this.serverStartupSettings.getBindAddress() : null);
            this.listener.start();
        }
        catch (InitializationException e) {
            logger.logException((Throwable)e);
        }
    }

    @Override
    public SearchResult search() {
        SearchResult result = new SearchResult();
        for (AccessPointInfo apInfo : this.imagoAPs.getAccessPoints()) {
            if (!apInfo.isNew() || AccessPointTypeMapping.getType((int)apInfo.getAccessPointId()) == AccessPointType.USB_AP) continue;
            ImagotagConfigHolder temp = new ImagotagConfigHolder(apInfo.getDiscoveryTime());
            temp.getBasicConfig().setApId(apInfo.getAccessPointId());
            if (apInfo.getServiceStatus() != null) {
                temp.getBasicConfig().setSubnetMask(apInfo.getServiceStatus().getServiceStatus().getPropertyValue("netmask"));
                temp.getBasicConfig().setHostname(apInfo.getServiceStatus().getHostname());
                temp.setThinAPModeEnabled(apInfo.getServiceStatus().isThinAPModeEnabled());
                if (temp.getThinAPModeEnabled()) {
                    temp.setOutboundModeEnabled(apInfo.getServiceStatus().isOutboundModeEnabled());
                    temp.setTlsEnabled(apInfo.getServiceStatus().getProtocolTLSEnabled());
                    if (temp.getOutboundModeEnabled()) {
                        temp.setApcAddress(apInfo.getServiceStatus().getApcAddress());
                        temp.setApcPort(apInfo.getServiceStatus().getApcPort());
                    }
                } else {
                    temp.setOutboundModeEnabled(false);
                }
            } else {
                temp.setThinAPModeEnabled(false);
            }
            temp.getBasicConfig().setWirelessChannel(apInfo.getChannel());
            temp.setAutoConfigEnabled(apInfo.getAutoConfig());
            try {
                ServiceAddress serviceAddress = ServiceAddress.fromString((String)apInfo.getAddress());
                temp.getBasicConfig().setAddress(serviceAddress.getHost());
                temp.setIsSslEnabled(serviceAddress.useSSL());
                temp.getBasicConfig().setPort(serviceAddress.getPort());
                apInfo.setNotNew();
                result.add(temp);
            }
            catch (MalformedURLException e) {
                logger.logExceptionIfDebugEnabled((Throwable)e);
            }
        }
        return result;
    }

    @Override
    public void stop() {
        if (this.listener != null) {
            this.listener.shutdown();
            this.listener = null;
        }
    }

    @Override
    public boolean isRunning() {
        return this.listener != null;
    }

    @Override
    public List<AccessPointInfo> getDiscoveredAccessPoints() {
        return this.imagoAPs.getAccessPoints();
    }

    @Override
    public void init(boolean sslEnabled, boolean discoveryEnabled) {
        this.imagoAPs.setDiscoveryEnabled(discoveryEnabled);
    }

    @Override
    public void receive(ModuleSpecificSettings settings) {
    }
}

