/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.server.provisioning.imagotag;

import at.mrdevelopment.esl.persistence.record.AccessPointInfo;
import at.mrdevelopment.esl.server.provisioning.ModuleSpecificSettings;
import at.mrdevelopment.esl.server.provisioning.decisionlogic.BaseDecisionLogicModule;
import at.mrdevelopment.esl.server.provisioning.decisionlogic.DecisionLogicModule;
import at.mrdevelopment.esl.server.provisioning.decisionlogic.ThinSettings;
import at.mrdevelopment.esl.server.provisioning.field.BaseExtConfigHolder;
import at.mrdevelopment.esl.server.provisioning.imagotag.CommonConfigHolder;
import at.mrdevelopment.esl.server.provisioning.imagotag.CommonFields;
import at.mrdevelopment.esl.server.provisioning.imagotag.ImagotagConfigHolder;
import at.mrdevelopment.esl.server.provisioning.imagotag.ImagotagModuleSettings;
import at.mrdevelopment.toolkit.Version;

public class ImagotagDecisionLogicModule
extends BaseDecisionLogicModule
implements DecisionLogicModule {
    private static final Version OLD_VERSION = new Version(1, 0, 0);
    private static final Version REQUIRED_VERSION = new Version(1, 8, 0, 0, "");
    private static final Version OUTBOUND_MODE_REQUIRED_VERSION = new Version(1, 9, 0, 0, "");
    private static final Version TLS_REQUIRED_VERSION = Version.fromString((String)"1.10.0");
    private ImagotagModuleSettings settings;

    @Override
    public void receive(ModuleSpecificSettings settings) {
        this.settings = (ImagotagModuleSettings)settings;
    }

    @Override
    public boolean likelyHappenedAfterLastUpdate(long lastUpdateTime, BaseExtConfigHolder newCurrentConfig) {
        return lastUpdateTime + 7000L < newCurrentConfig.getDiscoveryTime();
    }

    @Override
    public boolean didAuthenticationFail(BaseExtConfigHolder providedConfig) {
        return false;
    }

    @Override
    public boolean doWeTryInit(BaseExtConfigHolder providedConfig) {
        return false;
    }

    @Override
    public boolean isRfModuleWorking(BaseExtConfigHolder providedConfig) {
        return true;
    }

    @Override
    public boolean commonSettingsChanged() {
        return this.settings.commonSettingsChanged();
    }

    @Override
    public boolean isPasswordChangeRequired(BaseExtConfigHolder providedConfig) {
        return false;
    }

    @Override
    public boolean isInitAllowed(long lastInitTime) {
        return false;
    }

    @Override
    public boolean accessPointsRequireReinit() {
        return this.settings.accessPointsRequireReinit();
    }

    @Override
    public ThinSettings getThinConfig() {
        ThinSettings thinConfig = new ThinSettings();
        thinConfig.setThinModeEnabled(this.settings.getServerSettings().get(CommonFields.USE_THIN_MODE).getBoolValue());
        thinConfig.setOutboundModeEnabled(this.settings.getServerSettings().get(CommonFields.USE_OUTBOUND_MODE).getBoolValue());
        if (thinConfig.isOutboundModeEnabled()) {
            thinConfig.setApcAddress(this.settings.getServerSettings().get(CommonFields.APC_ADDRESS).getStringValue());
            thinConfig.setApcPort(this.settings.getServerSettings().get(CommonFields.APC_PORT).getIntValue());
        }
        return thinConfig;
    }

    @Override
    public boolean isOperationModeChangeRequired(ModuleSpecificSettings settings, BaseExtConfigHolder currentConfig) {
        boolean isChangeRequired;
        ImagotagModuleSettings temp = (ImagotagModuleSettings)settings;
        ImagotagConfigHolder imagoCurrent = (ImagotagConfigHolder)currentConfig;
        CommonConfigHolder configHolder = temp.getServerSettings();
        boolean bl = isChangeRequired = configHolder.get(CommonFields.USE_THIN_MODE).getBoolValue() != imagoCurrent.getThinAPModeEnabled();
        if (!isChangeRequired && imagoCurrent.getThinAPModeEnabled()) {
            boolean bl2 = isChangeRequired = this.hasTLSConfigChanged(settings, currentConfig) || configHolder.get(CommonFields.USE_OUTBOUND_MODE).getBoolValue() != imagoCurrent.getOutboundModeEnabled();
            if (!isChangeRequired && imagoCurrent.getOutboundModeEnabled()) {
                isChangeRequired = !configHolder.get(CommonFields.APC_ADDRESS).getStringValue().equals(imagoCurrent.getApcAddress()) || configHolder.get(CommonFields.APC_PORT).getIntValue() != imagoCurrent.getApcPort();
            }
        }
        return isChangeRequired;
    }

    @Override
    public boolean isOperationModeChangeSupported(ModuleSpecificSettings settings, AccessPointInfo apInfo) {
        Version ver = apInfo != null ? apInfo.getVersion() : OLD_VERSION;
        return ver != null && ver.isEqualOrNewer(REQUIRED_VERSION);
    }

    @Override
    public boolean isOutboundModeSupported(AccessPointInfo apInfo) {
        Version ver = apInfo != null ? apInfo.getVersion() : OLD_VERSION;
        return ver != null && ver.isEqualOrNewer(OUTBOUND_MODE_REQUIRED_VERSION);
    }

    @Override
    public boolean isTLSSupported(AccessPointInfo apInfo) {
        Version ver = apInfo != null ? apInfo.getVersion() : OLD_VERSION;
        return ver != null && ver.isEqualOrNewer(TLS_REQUIRED_VERSION);
    }

    @Override
    public boolean hasTLSConfigChanged(ModuleSpecificSettings settings, BaseExtConfigHolder currentConfig) {
        if (currentConfig != null && settings != null) {
            ImagotagModuleSettings temp = (ImagotagModuleSettings)settings;
            ImagotagConfigHolder imagoCurrent = (ImagotagConfigHolder)currentConfig;
            CommonConfigHolder configHolder = temp.getServerSettings();
            return configHolder.get(CommonFields.USE_THIN_SSL).getBoolValue() != imagoCurrent.isTlsEnabled();
        }
        return false;
    }
}

