/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.server.provisioning.imagotag;

import at.mrdevelopment.esl.admin.platform.DefaultAccessPointSystemAttributes;
import at.mrdevelopment.esl.admin.platform.EnvironmentProperties;
import at.mrdevelopment.esl.admin.platform.config.LogLevel;
import at.mrdevelopment.esl.admin.platform.config.LoggingConfiguration;
import at.mrdevelopment.esl.admin.platform.config.SSLConfiguration;
import at.mrdevelopment.esl.admin.platform.config.TimesyncConfiguration;
import at.mrdevelopment.esl.admin.platform.config.TrustStoreConfiguration;
import at.mrdevelopment.esl.admin.platform.config.WebserviceConfiguration;
import at.mrdevelopment.esl.admin.platform.config.accesspoint.AccessPointConfiguration;
import at.mrdevelopment.esl.admin.platform.config.accesspoint.AutoConfiguration;
import at.mrdevelopment.esl.admin.platform.config.accesspoint.BroadcastConfiguration;
import at.mrdevelopment.esl.admin.platform.config.accesspoint.ProtectionLevelConfiguration;
import at.mrdevelopment.esl.admin.platform.config.accesspoint.ThinAPConfiguration;
import at.mrdevelopment.esl.admin.platform.config.accesspoint.WirelessConfiguration;
import at.mrdevelopment.esl.admin.platform.config.network.NetworkConfiguration;
import at.mrdevelopment.esl.configuration.Config;
import at.mrdevelopment.esl.core.ServiceAddress;
import at.mrdevelopment.esl.msp.MSPConfiguration;
import at.mrdevelopment.esl.server.MSPConfigurationBuilder;
import at.mrdevelopment.esl.server.provisioning.ModuleSpecificSettings;
import at.mrdevelopment.esl.server.provisioning.configuration.ConfigurationModule;
import at.mrdevelopment.esl.server.provisioning.configuration.OperationResult;
import at.mrdevelopment.esl.server.provisioning.configuration.SuccessState;
import at.mrdevelopment.esl.server.provisioning.field.BaseExtConfigHolder;
import at.mrdevelopment.esl.server.provisioning.field.BasicConfigHolder;
import at.mrdevelopment.esl.server.provisioning.field.BasicFields;
import at.mrdevelopment.esl.server.provisioning.imagotag.CommonFields;
import at.mrdevelopment.esl.server.provisioning.imagotag.ImagotagAccessPointConfigClient;
import at.mrdevelopment.esl.server.provisioning.imagotag.ImagotagConfigHolder;
import at.mrdevelopment.esl.server.provisioning.imagotag.ImagotagModuleSettings;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.http.WebserviceException;
import at.mrdevelopment.toolkit.log.ESLLogger;
import at.mrdevelopment.toolkit.xml.SerializeException;
import org.apache.commons.lang.StringUtils;

public class ImagotagConfigurationModule
implements ConfigurationModule {
    private static final ESLLogger logger = ESLLogger.getLogger(ImagotagConfigurationModule.class);
    private static final int MAX_SEND_CONFIGURATION_TRIES = 5;
    private volatile boolean isRunning = false;
    private boolean sslEnabled = false;

    @Override
    public boolean setup(BaseExtConfigHolder currentConfig) {
        return true;
    }

    @Override
    public OperationResult updateAccessPointConfig(BasicConfigHolder configUpdateGoal, BaseExtConfigHolder currentConfig) {
        String hostname;
        ImagotagConfigHolder imagoConfigHolder = (ImagotagConfigHolder)currentConfig;
        AutoConfiguration autoConfiguration = AutoConfiguration.ENABLED;
        WirelessConfiguration wirelessConfiguration = configUpdateGoal.isSet(BasicFields.WIRELESS_CHANNEL) ? new WirelessConfiguration(configUpdateGoal.getWirelessChannel()) : new WirelessConfiguration(imagoConfigHolder.getBasicConfig().getWirelessChannel());
        NetworkConfiguration networkConfiguration = null;
        boolean targetConfigHasSomeHostname = configUpdateGoal.getHostname() != null && !configUpdateGoal.getHostname().isEmpty();
        String string = hostname = targetConfigHasSomeHostname ? configUpdateGoal.getHostname() : DefaultAccessPointSystemAttributes.createDefaultHostname((int)currentConfig.getBasicConfig().getApId());
        if (configUpdateGoal.getAddress() == null || configUpdateGoal.getAddress().isEmpty()) {
            networkConfiguration = new NetworkConfiguration(hostname);
        } else {
            String address = configUpdateGoal.getAddress();
            String mask = configUpdateGoal.getSubnetMask();
            String gateway = configUpdateGoal.getGatewayAddress();
            String dns = configUpdateGoal.getDnsAddress();
            if (StringUtils.isBlank((String)address) || StringUtils.isBlank((String)mask)) {
                logger.warn("Tried to send config with problematic network configuration.");
                return new OperationResult();
            }
            networkConfiguration = new NetworkConfiguration(hostname, address, mask, gateway, dns, "");
        }
        TimesyncConfiguration timesyncConfiguration = new TimesyncConfiguration(Config.isTimesyncEnabled(), Config.getTimeServer(), Config.getTimesyncUpdateIntervalInMinutes());
        MSPConfiguration mspConfiguration = null;
        try {
            mspConfiguration = MSPConfigurationBuilder.createMSPConfigurationForAccessPoint(new EnvironmentProperties(false));
        }
        catch (InitializationException e) {
            logger.logException((Throwable)e);
        }
        BroadcastConfiguration broadcastConfiguration = new BroadcastConfiguration(Config.isBroadcastEnabled(), Config.getBroadcastIntervalInMinutes(), Config.getBroadcastPort());
        LoggingConfiguration loggingConfiguration = new LoggingConfiguration(LogLevel.parseString((String)Config.getLogLevel()), Config.getLogSocketAppenderPort(), Config.getLogSocketAppenderRemoteAddress(), Config.isLogSocketAppenderEnabled());
        AccessPointConfiguration accessPointConfiguration = new AccessPointConfiguration(autoConfiguration, wirelessConfiguration, networkConfiguration, timesyncConfiguration, mspConfiguration, broadcastConfiguration, loggingConfiguration, new SSLConfiguration(), new WebserviceConfiguration(), new TrustStoreConfiguration(), new ThinAPConfiguration(7353), new ProtectionLevelConfiguration());
        OperationResult configResult = new OperationResult();
        ImagotagConfigHolder resultConfigHolder = new ImagotagConfigHolder(0L);
        boolean sendSuccessful = false;
        try {
            sendSuccessful = this.sendConfiguration(imagoConfigHolder, accessPointConfiguration);
            if (sendSuccessful) {
                String address;
                resultConfigHolder.customOvertake(configUpdateGoal);
                if (configUpdateGoal.isSet(BasicFields.IP_ADDRESS) && !(address = configUpdateGoal.getAddress()).equals(currentConfig.getBasicConfig().getAddress())) {
                    configResult.setRequiresServiceReinit(true);
                }
            }
        }
        catch (SerializeException se) {
            logger.logException((Throwable)se);
        }
        configResult.setState(sendSuccessful ? SuccessState.SUCCESSFUL : SuccessState.NOT_SUCCESSFUL);
        configResult.setExtHolder(resultConfigHolder);
        return configResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean sendConfiguration(ImagotagConfigHolder imagoConfigHolder, AccessPointConfiguration accessPointConfiguration) throws SerializeException {
        ServiceAddress newServiceAddress = this.createAccessPointServiceAddress(imagoConfigHolder);
        ImagotagAccessPointConfigClient configClient = null;
        try {
            configClient = new ImagotagAccessPointConfigClient(newServiceAddress);
            for (int retry = 0; retry < 5; ++retry) {
                try {
                    logger.info("---------------------------retryCount: " + retry);
                    configClient.sendConfiguration(accessPointConfiguration);
                    boolean bl = true;
                    return bl;
                }
                catch (WebserviceException exc) {
                    try {
                        logger.logExceptionIfDebugEnabled((Throwable)exc);
                        logger.warn("Failed to send configuration to %s: %s.", new Object[]{newServiceAddress, exc.getMessage()});
                        continue;
                    }
                    catch (InitializationException ie) {
                        logger.logExceptionIfDebugEnabled((Throwable)ie);
                        logger.warn("Failed to create configuration client to %s: %s", new Object[]{newServiceAddress, ie.getMessage()});
                        return false;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                        return false;
                    }
                }
            }
        }
        finally {
            if (configClient != null) {
                configClient.shutdown();
            }
        }
    }

    private ServiceAddress createAccessPointServiceAddress(ImagotagConfigHolder imagoConfigHolder) {
        return this.createAccessPointServiceAddress(imagoConfigHolder.isSslEnabled(), imagoConfigHolder.getBasicConfig().getAddress(), imagoConfigHolder.getBasicConfig().getPort());
    }

    private ServiceAddress createAccessPointServiceAddress(boolean sslEnabled, String address, int port) {
        ServiceAddress serviceAddress = new ServiceAddress(sslEnabled, address, port, "admin", Config.getAccessPointAdministrationPassword());
        return serviceAddress;
    }

    @Override
    public boolean isRunning() {
        return this.isRunning;
    }

    @Override
    public void start() {
        this.isRunning = true;
    }

    @Override
    public void stop() {
        this.isRunning = false;
    }

    @Override
    public void receive(ModuleSpecificSettings settings) {
    }

    @Override
    public OperationResult initAccessPoint(BaseExtConfigHolder currentConfig) {
        throw new UnsupportedOperationException("initAccessPoint(...) is not supposed to be used for the imagotag AP");
    }

    @Override
    public OperationResult turnOnRfModule(BaseExtConfigHolder currentConfig) {
        throw new UnsupportedOperationException("turnOnRfModule(...) is not supposed to be used for the imagotag AP");
    }

    @Override
    public OperationResult changePassword(BaseExtConfigHolder currentConfig) {
        throw new UnsupportedOperationException("changePassword(...) is not supposed to be used for the imagotag AP");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OperationResult innerChangeOperationMode(ModuleSpecificSettings settings, ServiceAddress newServiceAddress) {
        ImagotagAccessPointConfigClient configClient = null;
        OperationResult result = new OperationResult();
        ImagotagConfigHolder resultConfigHolder = new ImagotagConfigHolder(0L);
        try {
            ImagotagModuleSettings imagoSettings = (ImagotagModuleSettings)settings;
            configClient = new ImagotagAccessPointConfigClient(newServiceAddress);
            boolean thinModeEnabled = imagoSettings.getServerSettings().get(CommonFields.USE_THIN_MODE).getBoolValue();
            configClient.sendOperationMode(thinModeEnabled, imagoSettings.getServerSettings().get(CommonFields.USE_OUTBOUND_MODE).getBoolValue(), imagoSettings.getServerSettings().get(CommonFields.APC_ADDRESS).getStringValue(), imagoSettings.getServerSettings().get(CommonFields.APC_PORT).getIntValue(), imagoSettings.getServerSettings().get(CommonFields.USE_THIN_SSL).getBoolValue());
            resultConfigHolder.setThinAPModeEnabled(thinModeEnabled);
            result.setExtHolder(resultConfigHolder);
            result.setState(SuccessState.SUCCESSFUL);
        }
        catch (SerializeException se) {
            logger.warn("Failed to serialize operation mode for Imagotag Access Point.");
            logger.logExceptionIfDebugEnabled((Throwable)se);
        }
        catch (WebserviceException exc) {
            logger.warn("Failed to send operation mode to %s: %s.", new Object[]{newServiceAddress, exc.getMessage()});
            logger.logExceptionIfDebugEnabled((Throwable)exc);
        }
        catch (InitializationException ie) {
            logger.warn("Failed to create imagotag access point config client to %s: %s", new Object[]{newServiceAddress, ie.getMessage()});
            logger.logExceptionIfDebugEnabled((Throwable)ie);
        }
        finally {
            if (configClient != null) {
                configClient.shutdown();
            }
        }
        return result;
    }

    @Override
    public OperationResult changeOperationMode(ModuleSpecificSettings settings, BaseExtConfigHolder currentConfig) {
        ServiceAddress newServiceAddress = this.createAccessPointServiceAddress((ImagotagConfigHolder)currentConfig);
        return this.innerChangeOperationMode(settings, newServiceAddress);
    }

    @Override
    public OperationResult changeOperationMode(ModuleSpecificSettings settings, BasicConfigHolder configUpdateGoal) {
        ServiceAddress newServiceAddress = this.createAccessPointServiceAddress(this.sslEnabled, configUpdateGoal.getAddress(), configUpdateGoal.getPort());
        return this.innerChangeOperationMode(settings, newServiceAddress);
    }

    @Override
    public void init(boolean sslEnabled) {
        this.sslEnabled = sslEnabled;
    }
}

