/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.server.provisioning.imagotag;

import at.mrdevelopment.esl.server.provisioning.field.BaseConfigHolder;
import at.mrdevelopment.esl.server.provisioning.field.BaseExtConfigHolder;
import at.mrdevelopment.esl.server.provisioning.field.BasicFields;
import at.mrdevelopment.esl.server.provisioning.field.ConfigField;
import at.mrdevelopment.esl.server.provisioning.field.Difference;
import at.mrdevelopment.esl.server.provisioning.imagotag.ImagotagFields;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;

public class ImagotagConfigHolder
extends BaseExtConfigHolder {
    static final Collection<ConfigField> FIELDS_TO_IGNORE = Collections.singletonList(BasicFields.PORT);
    static final Collection<ConfigField> FIELDS_TO_IGNORE_FOR_DIFFERENCE = new LinkedList<ConfigField>();

    public ImagotagConfigHolder(long discoveryTimeInMillis) {
        super(ImagotagFields.FIELDS, discoveryTimeInMillis);
        this.setTlsEnabled(false);
    }

    public boolean getAutoConfigEnabled() {
        return this.get(ImagotagFields.AUTO_CONFIG_ENABLED).getBoolValue();
    }

    void setAutoConfigEnabled(boolean enabled) {
        this.set(ImagotagFields.AUTO_CONFIG_ENABLED, enabled);
    }

    public boolean getThinAPModeEnabled() {
        return this.get(ImagotagFields.THINAP_MODE_ENABLED).getBoolValue();
    }

    void setThinAPModeEnabled(boolean enabled) {
        this.set(ImagotagFields.THINAP_MODE_ENABLED, enabled);
    }

    public boolean getOutboundModeEnabled() {
        return this.get(ImagotagFields.OUTBOUND_MODE_ENABLED).getBoolValue();
    }

    void setOutboundModeEnabled(boolean enabled) {
        this.set(ImagotagFields.OUTBOUND_MODE_ENABLED, enabled);
    }

    public String getApcAddress() {
        return this.get(ImagotagFields.APC_ADDRESS).getStringValue();
    }

    void setApcAddress(String apcAddress) {
        this.set(ImagotagFields.APC_ADDRESS, apcAddress);
    }

    public int getApcPort() {
        return this.get(ImagotagFields.APC_PORT).getIntValue();
    }

    void setApcPort(int apcPort) {
        this.set(ImagotagFields.APC_PORT, apcPort);
    }

    public boolean isTlsEnabled() {
        return this.get(ImagotagFields.IS_TLS_ENABLED).getBoolValue();
    }

    void setTlsEnabled(boolean enabled) {
        this.set(ImagotagFields.IS_TLS_ENABLED, enabled);
    }

    public boolean isSslEnabled() {
        return this.get(ImagotagFields.IS_SSL_ENABLED).getBoolValue();
    }

    void setIsSslEnabled(boolean enabled) {
        this.set(ImagotagFields.IS_SSL_ENABLED, enabled);
    }

    public String getWebUsername() {
        return this.get(ImagotagFields.WEB_USERNAME).getStringValue();
    }

    void setWebUsername(String username) {
        this.set(ImagotagFields.WEB_USERNAME, username);
    }

    public String getWebPassword() {
        return this.get(ImagotagFields.WEB_PASSWORD).getStringValue();
    }

    void setWebPassword(String password) {
        this.set(ImagotagFields.WEB_PASSWORD, password);
    }

    @Override
    public BaseExtConfigHolder copy() {
        ImagotagConfigHolder imagoConfigHolder = new ImagotagConfigHolder(this.discoveryTimeInMillis);
        imagoConfigHolder.transferFrom(this);
        return imagoConfigHolder;
    }

    public void customOvertake(BaseConfigHolder from) {
        super.overtake(from, FIELDS_TO_IGNORE);
    }

    @Override
    public void customOvertake(BaseExtConfigHolder from) {
        super.overtake(from, FIELDS_TO_IGNORE);
    }

    @Override
    public Difference isDifferentFrom(BaseExtConfigHolder other) {
        return super.isDifferentFrom(other, FIELDS_TO_IGNORE_FOR_DIFFERENCE);
    }

    static {
        FIELDS_TO_IGNORE_FOR_DIFFERENCE.add(BasicFields.PORT);
        FIELDS_TO_IGNORE_FOR_DIFFERENCE.add(BasicFields.GATEWAY_ADDRESS);
        FIELDS_TO_IGNORE_FOR_DIFFERENCE.add(BasicFields.DNS_ADDRESS);
    }
}

