/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.server.provisioning.field;

import at.mrdevelopment.esl.server.provisioning.field.ConfigField;
import at.mrdevelopment.esl.server.provisioning.field.ConfigFieldValue;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class BaseConfigHolder {
    protected HashMap<ConfigField, ConfigFieldValue> configFields = new HashMap();

    protected BaseConfigHolder(List<ConfigField> fields) {
        for (ConfigField cf : fields) {
            this.configFields.put(cf, new ConfigFieldValue(cf.getType()));
        }
    }

    protected void transferFrom(BaseConfigHolder other) {
        for (Map.Entry<ConfigField, ConfigFieldValue> e : other.configFields.entrySet()) {
            this.set(e.getKey(), other.get(e.getKey()).getValue());
        }
    }

    public Set<Map.Entry<ConfigField, ConfigFieldValue>> getConfigFields() {
        return this.configFields.entrySet();
    }

    public void set(ConfigField cf, Object value) {
        ConfigFieldValue cfv = this.configFields.get(cf);
        if (cfv == null) {
            throw new IllegalArgumentException("Config field is not known!");
        }
        if (value == null) {
            cfv.setValue(null);
        } else if (cf.getType().getActualClass().isInstance(value)) {
            cfv.setValue(value);
        } else {
            throw new IllegalArgumentException("Provided value does not match type of config field: " + cf.toString());
        }
    }

    public ConfigFieldValue get(ConfigField cf) {
        ConfigFieldValue cfv = this.configFields.get(cf);
        if (cfv == null) {
            throw new IllegalArgumentException("Config field is not known!");
        }
        return cfv;
    }

    public boolean isSet(ConfigField cf) {
        ConfigFieldValue cfv = this.configFields.get(cf);
        if (cfv == null) {
            throw new IllegalArgumentException("Config field is not known!");
        }
        return cfv.isSet();
    }

    public void regularOvertake(BaseConfigHolder from) {
        this.overtake(from, Collections.<ConfigField>emptyList());
    }

    protected void overtake(BaseConfigHolder from, Collection<ConfigField> fieldsToIgnore) {
        for (Map.Entry<ConfigField, ConfigFieldValue> entry : this.configFields.entrySet()) {
            ConfigFieldValue cfvFrom;
            if (fieldsToIgnore.contains(entry.getKey()) || !(cfvFrom = from.get(entry.getKey())).isSet()) continue;
            entry.getValue().setValue(cfvFrom.getValue());
        }
    }

    public boolean isDifferentFrom(BaseConfigHolder other, Collection<ConfigField> fieldsToIgnore) {
        for (Map.Entry<ConfigField, ConfigFieldValue> entry : this.configFields.entrySet()) {
            if (fieldsToIgnore.contains(entry.getKey())) continue;
            ConfigFieldValue cfvOther = other.get(entry.getKey());
            if (!(entry.getValue().isSet() ? !entry.getValue().matches(cfvOther) : cfvOther.isSet())) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("BaseConfigHolder [configFields=");
        builder.append(this.configFields);
        builder.append("]");
        return builder.toString();
    }
}

