/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.server.provisioning;

import at.mrdevelopment.esl.admin.platform.EnvironmentProperties;
import at.mrdevelopment.esl.persistence.DatasetException;
import at.mrdevelopment.esl.persistence.dataset.AccessPointConfigurationDataset;
import at.mrdevelopment.esl.persistence.dataset.AccessPointInfoDataset;
import at.mrdevelopment.esl.persistence.dataset.Transaction;
import at.mrdevelopment.esl.persistence.dataset.util.AccessPointUpdate;
import at.mrdevelopment.esl.persistence.record.AccessPointConfiguration;
import at.mrdevelopment.esl.server.provisioning.AccessPointTypeModules;
import at.mrdevelopment.esl.server.provisioning.ProvisioningModule;
import at.mrdevelopment.esl.server.provisioning.ProvisioningSituationHelper;
import at.mrdevelopment.esl.server.provisioning.decisionlogic.DecisionMode;
import at.mrdevelopment.esl.server.provisioning.decisionlogic.TargetConfigValidity;
import at.mrdevelopment.esl.server.provisioning.field.BasicConfigHolder;
import at.mrdevelopment.esl.server.provisioning.message.AccessPointProvisioningQueries;
import at.mrdevelopment.esl.server.provisioning.resolution.CentralizedResolution;
import at.mrdevelopment.esl.server.provisioning.resolution.ManualResolution;
import at.mrdevelopment.esl.server.provisioning.resolution.OtherResolution;
import at.mrdevelopment.esl.server.provisioning.situation.AccessPointConfigSituation;
import at.mrdevelopment.esl.server.provisioning.situation.InitResult;
import at.mrdevelopment.toolkit.log.ESLLogger;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class SituationsUpdateProcessing {
    private static final ESLLogger logger = ESLLogger.getLogger(SituationsUpdateProcessing.class);
    private final AccessPointProvisioningQueries apProvisioningQueries;
    private final AccessPointInfoDataset infoDataset;
    private final ProvisioningModule provisioningModule;
    private final ProvisioningSituationHelper situationsHelper;

    public SituationsUpdateProcessing(ProvisioningModule provisioningModule, AccessPointProvisioningQueries apProvisioningQueries, AccessPointInfoDataset infoDataset) {
        this.provisioningModule = provisioningModule;
        this.apProvisioningQueries = apProvisioningQueries;
        this.infoDataset = infoDataset;
        this.situationsHelper = new ProvisioningSituationHelper(logger, infoDataset, apProvisioningQueries);
    }

    public void executeSituationsUpdate(Map<Integer, AccessPointConfigSituation> apConfigMapping, AccessPointConfigurationDataset configDataset, EnvironmentProperties environmentProperties, Transaction<?> transaction) {
        this.addOrUpdateSituationsBasedOnConfigurations(configDataset, apConfigMapping, transaction);
        for (AccessPointConfigSituation situation : apConfigMapping.values()) {
            boolean serverSideRequiresUpdate;
            boolean isAnyConfigNew;
            situation.clearValidity();
            situation.context().clear();
            if (!situation.isTargetConfigurationPresent()) continue;
            boolean bl = isAnyConfigNew = situation.isCurrentConfigurationPresent() && situation.isAnyConfigNew();
            if (isAnyConfigNew) {
                situation.updatePeriodic();
            }
            if (situation.getDecisionMode() == DecisionMode.MANUAL) {
                this.processManualConfig(situation, environmentProperties);
                continue;
            }
            InitResult res = InitResult.NOT_NEEDED;
            if (situation.isCurrentConfigurationPresent() && (situation.isAnyConfigNew() || situation.didAuthenticationFail()) && (res = situation.initHandler().perform()) == InitResult.FAILED) {
                this.situationsHelper.goOffline(situation, environmentProperties, OtherResolution.INITIALIZATION_FAILED);
                situation.setBothConfigsToOld();
                situation.periodic().handled(OtherResolution.INITIALIZATION_FAILED, isAnyConfigNew);
            }
            if (res == InitResult.FAILED || res == InitResult.NOT_ALLOWED || !situation.isDiscoveryEnabled()) continue;
            TargetConfigValidity targetConfigValidity = situation.getTargetConfigurationValidity();
            boolean canUpdate = situation.canUpdate();
            boolean bl2 = serverSideRequiresUpdate = situation.isCurrentConfigurationPresent() && situation.requireConfigUpdateDueCommonSettingsChange();
            if (canUpdate && (isAnyConfigNew || serverSideRequiresUpdate) && targetConfigValidity != TargetConfigValidity.NOT_VALID && situation.setup()) {
                situation.update();
            }
            this.processAutoConfig(situation, environmentProperties, isAnyConfigNew, serverSideRequiresUpdate, canUpdate, targetConfigValidity);
        }
    }

    private void addOrUpdateSituationsBasedOnConfigurations(AccessPointConfigurationDataset configDataset, Map<Integer, AccessPointConfigSituation> apConfigMapping, Transaction<?> transaction) {
        TreeSet<Integer> configuredAps = new TreeSet<Integer>();
        try {
            for (AccessPointConfiguration apc : configDataset.queryAll(transaction)) {
                configuredAps.add(apc.getAccessPointId());
                AccessPointConfigSituation situation = apConfigMapping.get(apc.getAccessPointId());
                if (situation == null) {
                    AccessPointTypeModules currentApm = this.provisioningModule.getAccessPointTypeModules(apc.getAccessPointId());
                    BasicConfigHolder newTargetConfig = BasicConfigHolder.createFrom(apc);
                    logger.info("Initial update for AP = %d configuration: %s.", new Object[]{apc.getAccessPointId(), newTargetConfig.toString()});
                    situation = new AccessPointConfigSituation(currentApm, this.infoDataset, newTargetConfig);
                    apConfigMapping.put(apc.getAccessPointId(), situation);
                    continue;
                }
                BasicConfigHolder newTarget = BasicConfigHolder.createFrom(apc);
                if (!situation.anyDifferentFromTarget(newTarget)) continue;
                logger.info("Updating AP = %d configuration: %s.", new Object[]{newTarget.getApId(), newTarget.toString()});
                situation.overtakeTarget(newTarget);
            }
            this.removeExpiredSituationMappings(configuredAps, apConfigMapping);
        }
        catch (DatasetException de) {
            logger.error("Error querying AccessPointConfigurationDataset.", new Object[]{de.getMessage()});
            logger.logExceptionIfDebugEnabled((Throwable)de);
        }
    }

    private void processAutoConfig(AccessPointConfigSituation situation, EnvironmentProperties environmentProperties, boolean inNeedOfUpdate, boolean serverSideUpdateRequired, boolean canUpdate, TargetConfigValidity targetConfigValidity) {
        if (situation.isCurrentConfigurationPresent()) {
            if (situation.periodic().requiresHandling()) {
                if (!situation.periodic().isDisabled()) {
                    situation.setOffline();
                    situation.makeAccessPointServiceGoOffline(this.infoDataset, environmentProperties);
                    this.situationsHelper.logOffline(situation, CentralizedResolution.UNRESOLVABLE);
                    situation.periodic().disable();
                    situation.setTargetConfigToOld();
                    situation.accessPointDoNotRequireReinit();
                }
                return;
            }
            if (situation.context().wasUpdateSuccessful()) {
                this.situationsHelper.situationOnlineOfflineLogic(situation, CentralizedResolution.SUCCESSFUL_UPDATE, environmentProperties);
                situation.setBothConfigsToOld();
                situation.accessPointDoNotRequireReinit();
                situation.periodic().handled(CentralizedResolution.SUCCESSFUL_UPDATE, situation.isAnyConfigNew());
            } else if (situation.isAnyConfigNew()) {
                if (targetConfigValidity == TargetConfigValidity.NOT_VALID) {
                    this.situationsHelper.goOffline(situation, environmentProperties, CentralizedResolution.TARGET_CONFIG_NOT_VALID);
                    situation.setBothConfigsToOld();
                    situation.accessPointDoNotRequireReinit();
                    situation.periodic().handled(CentralizedResolution.TARGET_CONFIG_NOT_VALID, situation.isAnyConfigNew());
                } else if (inNeedOfUpdate || serverSideUpdateRequired) {
                    if (canUpdate) {
                        this.situationsHelper.goOffline(situation, environmentProperties, CentralizedResolution.UPDATE_FAILED);
                        situation.setBothConfigsToOld();
                        situation.accessPointDoNotRequireReinit();
                        situation.periodic().handled(CentralizedResolution.UPDATE_FAILED, situation.isAnyConfigNew());
                    } else {
                        this.situationsHelper.goOffline(situation, environmentProperties, CentralizedResolution.AUTOCONFIG_NOT_ENABLED);
                        situation.setBothConfigsToOld();
                        situation.accessPointDoNotRequireReinit();
                    }
                } else {
                    this.situationsHelper.situationOnlineOfflineLogic(situation, CentralizedResolution.UPDATE_NOT_NEEDED, environmentProperties);
                    situation.setBothConfigsToOld();
                    situation.accessPointDoNotRequireReinit();
                    situation.periodic().handled(CentralizedResolution.UPDATE_NOT_NEEDED, situation.isAnyConfigNew());
                }
            } else if (serverSideUpdateRequired) {
                if (canUpdate) {
                    this.situationsHelper.goOffline(situation, environmentProperties, CentralizedResolution.UPDATE_FAILED);
                    situation.setBothConfigsToOld();
                    situation.accessPointDoNotRequireReinit();
                    situation.periodic().handled(CentralizedResolution.UPDATE_FAILED, situation.isAnyConfigNew());
                } else {
                    this.situationsHelper.goOffline(situation, environmentProperties, CentralizedResolution.AUTOCONFIG_NOT_ENABLED);
                    situation.accessPointDoNotRequireReinit();
                    situation.setBothConfigsToOld();
                }
            } else if (situation.accessPointsRequireReinit()) {
                this.situationsHelper.situationOnlineOfflineLogic(situation, OtherResolution.ACCESS_POINT_REINIT_REQUIRED, environmentProperties);
                situation.accessPointDoNotRequireReinit();
            }
        } else if (situation.isTargetConfigNew()) {
            situation.setOffline();
            situation.makeAccessPointServiceGoOffline(this.infoDataset, environmentProperties);
            this.situationsHelper.logOffline(situation, CentralizedResolution.NOT_DISCOVERED);
            situation.setTargetConfigToOld();
            situation.periodic().handled(CentralizedResolution.NOT_DISCOVERED, true);
        }
    }

    private void processManualConfig(AccessPointConfigSituation situation, EnvironmentProperties env) {
        TargetConfigValidity validity = situation.getTargetConfigurationValidity();
        if (validity == TargetConfigValidity.MANUAL_BASIC) {
            if (situation.isTargetConfigNew() || situation.accessPointsRequireReinit()) {
                situation.setOnline();
                AccessPointUpdate.Builder builder = new AccessPointUpdate.Builder();
                builder.accessPointId(situation.getApId()).serviceAddress(situation.createServiceAddress(env));
                builder.isPermanentlyOffline(false).serviceToBeInitialized(true).autoConfig(situation.canUpdate());
                builder.thinMode(situation.isThinModeEnabled());
                this.infoDataset.updateAccessPoint(builder.build());
                this.situationsHelper.logOnline(situation, ManualResolution.BASIC);
                situation.setBothConfigsToOld();
                situation.accessPointDoNotRequireReinit();
            } else {
                situation.setBothConfigsToOld();
            }
        } else if (validity == TargetConfigValidity.MANUAL_ID_ONLY) {
            if (situation.isCurrentConfigurationPresent()) {
                if (situation.isAnyConfigNew() || situation.accessPointsRequireReinit()) {
                    this.situationsHelper.goOnline(situation, env, ManualResolution.ID_ONLY);
                    situation.setBothConfigsToOld();
                    situation.accessPointDoNotRequireReinit();
                }
            } else if (situation.isTargetConfigNew() || situation.accessPointsRequireReinit()) {
                this.situationsHelper.goOnline(situation, env, ManualResolution.ID_ONLY);
                situation.setBothConfigsToOld();
                situation.accessPointDoNotRequireReinit();
            }
        } else if (situation.isTargetConfigNew() || situation.isCurrentConfigurationPresent() && situation.isCurrentConfigNew() || situation.accessPointsRequireReinit()) {
            situation.setOffline();
            situation.makeAccessPointServiceGoOffline(this.infoDataset, env);
            this.situationsHelper.logOffline(situation, ManualResolution.TARGET_CONFIG_NOT_VALID);
            situation.setBothConfigsToOld();
            situation.accessPointDoNotRequireReinit();
        }
    }

    private void removeExpiredSituationMappings(Set<Integer> configuredAps, Map<Integer, AccessPointConfigSituation> apConfigMapping) {
        long currentTimeInMillis = System.currentTimeMillis();
        Iterator<Map.Entry<Integer, AccessPointConfigSituation>> iterator = apConfigMapping.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Integer, AccessPointConfigSituation> entry = iterator.next();
            AccessPointConfigSituation situation = entry.getValue();
            if (!configuredAps.contains(entry.getKey())) {
                situation.clearTargetAndReset();
                this.apProvisioningQueries.unsetProblem(entry.getKey());
            }
            situation.clearCurrentIfExpired(currentTimeInMillis);
            if (!situation.isEmpty()) continue;
            logger.info("Removing situation mapping for AP = %d.", new Object[]{(int)entry.getKey()});
            iterator.remove();
        }
    }
}

