/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.server.provisioning;

import at.mrdevelopment.esl.server.provisioning.field.BaseExtConfigHolder;
import at.mrdevelopment.esl.server.provisioning.field.BasicConfigHolder;
import at.mrdevelopment.esl.server.provisioning.field.ConfigField;
import at.mrdevelopment.esl.server.provisioning.resolution.SituationResolution;
import at.mrdevelopment.toolkit.log.ESLLogger;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang.ObjectUtils;

public class PeriodicSituation {
    private static ESLLogger logger = ESLLogger.getLogger(PeriodicSituation.class);
    private BasicConfigHolder targetConfiguration;
    private BaseExtConfigHolder currentConfiguration;
    private int handledCount = 0;
    private List<ResolutionSnapshot> resolutions = new LinkedList<ResolutionSnapshot>();
    private boolean periodicSituationDisabled = false;

    public void update(BasicConfigHolder targetConfiguration, BaseExtConfigHolder currentConfiguration) {
        if (this.targetConfiguration == null) {
            this.targetConfiguration = targetConfiguration.copy();
            this.resetCount();
        } else if (this.targetConfiguration.isDifferentFrom(targetConfiguration, Collections.<ConfigField>emptyList())) {
            this.targetConfiguration = targetConfiguration.copy();
            this.resetCount();
            this.periodicSituationDisabled = false;
        }
        if (this.currentConfiguration == null) {
            this.currentConfiguration = currentConfiguration.copy();
            this.resetCount();
        } else if (this.currentConfiguration.isDifferentFrom(currentConfiguration, Collections.<ConfigField>emptyList()).isDifferent()) {
            this.currentConfiguration = currentConfiguration.copy();
            this.resetCount();
            this.periodicSituationDisabled = false;
        }
    }

    public void resetCount() {
        this.handledCount = 0;
        this.resolutions.clear();
    }

    public void handled(SituationResolution resolution, boolean anyConfigNew) {
        ++this.handledCount;
        this.resolutions.add(new ResolutionSnapshot(resolution, anyConfigNew));
        if (this.handledCount > 1) {
            logger.info("Handled count = %d, TC = %s, CC = %s.", new Object[]{this.handledCount, ObjectUtils.toString((Object)this.targetConfiguration, (String)"null"), ObjectUtils.toString((Object)this.currentConfiguration, (String)"null")});
        }
    }

    public boolean requiresHandling() {
        return this.handledCount > 3;
    }

    public boolean isDisabled() {
        return this.periodicSituationDisabled;
    }

    public void disable() {
        this.periodicSituationDisabled = true;
        StringBuilder stb = new StringBuilder(368);
        stb.append("Following periodic situation was permanently disabled. TARGET = ");
        stb.append(this.targetConfiguration).append(" CURRENT = ").append(this.currentConfiguration).append(".");
        stb.append(" RESOLUTIONS = ");
        for (ResolutionSnapshot rs : this.resolutions) {
            stb.append(rs.toString()).append(", ");
        }
        logger.error(stb.toString());
    }

    class ResolutionSnapshot {
        private SituationResolution resolution;
        private boolean anyConfigNew;

        public ResolutionSnapshot(SituationResolution resolution, boolean anyConfigNew) {
            this.resolution = resolution;
            this.anyConfigNew = anyConfigNew;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("ResolutionSnapshot [resolution=");
            builder.append(this.resolution.getProblem().name());
            builder.append(", anyConfigNew=");
            builder.append(this.anyConfigNew);
            builder.append("]");
            return builder.toString();
        }
    }
}

