/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.server.provisioning;

import at.mrdevelopment.esl.core.TransactionalESLProcessingTask;
import at.mrdevelopment.esl.persistence.dataset.Transaction;
import at.mrdevelopment.esl.persistence.dataset.TransactionSupplier;
import at.mrdevelopment.esl.server.provisioning.ProvisioningModule;

public class PartialProvisioningProcessingTask
extends TransactionalESLProcessingTask {
    private final ProvisioningModule module;
    private final int accessPointId;

    public PartialProvisioningProcessingTask(TransactionSupplier transactionSupplier, ProvisioningModule module) {
        this(transactionSupplier, module, -1);
    }

    public PartialProvisioningProcessingTask(TransactionSupplier transactionSupplier, ProvisioningModule module, int accessPointId) {
        super(transactionSupplier);
        this.module = module;
        this.accessPointId = accessPointId;
    }

    public void run() throws Exception {
        Transaction transaction = this.getTransactionSupplier().newTransaction();
        try {
            if (this.accessPointId == -1) {
                this.module.externalExecuteSituationsUpdate(transaction);
            } else {
                this.module.executeAccessPointRemoval(this.accessPointId);
            }
            transaction.commit();
        }
        catch (Exception exc) {
            transaction.rollback();
            throw exc;
        }
    }
}

