/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.server.provisioning;

import at.mrdevelopment.esl.core.accesspoint.AccessPointType;
import at.mrdevelopment.esl.persistence.dataset.AccessPointInfoDataset;
import at.mrdevelopment.esl.server.provisioning.AccessPointTypeModules;
import at.mrdevelopment.esl.server.provisioning.discovery.SearchResult;
import at.mrdevelopment.esl.server.provisioning.field.BaseExtConfigHolder;
import at.mrdevelopment.esl.server.provisioning.situation.AccessPointConfigSituation;
import at.mrdevelopment.toolkit.log.ESLLogger;
import java.util.Map;

public class DiscoveryModuleProcessing {
    private static final ESLLogger logger = ESLLogger.getLogger(DiscoveryModuleProcessing.class);
    private final AccessPointInfoDataset infoDataset;

    public DiscoveryModuleProcessing(AccessPointInfoDataset infoDataset) {
        this.infoDataset = infoDataset;
    }

    public void startOrStopExecutionOfModules(Map<AccessPointType, AccessPointTypeModules> apType2ModulesMapping) {
        for (AccessPointTypeModules apm : apType2ModulesMapping.values()) {
            this.startOrStopExecutionOfModules(apm);
        }
    }

    public void processDiscovery(Map<Integer, AccessPointConfigSituation> apConfigMapping, Map<AccessPointType, AccessPointTypeModules> apType2ModulesMapping) {
        for (AccessPointTypeModules apm : apType2ModulesMapping.values()) {
            this.executeModuleDiscoverySteps(apConfigMapping, apm);
        }
    }

    private void startOrStopExecutionOfModules(AccessPointTypeModules apm) {
        if (apm.getLatestSettings() != null) {
            if (apm.getLatestSettings().isDiscoveryEnabled()) {
                if (!apm.discoveryModule.isRunning()) {
                    apm.discoveryModule.start();
                }
                if (!apm.configModule.isRunning()) {
                    apm.configModule.start();
                }
            } else {
                if (apm.discoveryModule.isRunning()) {
                    apm.discoveryModule.stop();
                }
                if (apm.configModule.isRunning()) {
                    apm.configModule.stop();
                }
            }
        }
    }

    private void executeModuleDiscoverySteps(Map<Integer, AccessPointConfigSituation> apConfigMapping, AccessPointTypeModules apm) {
        SearchResult result = apm.discoveryModule.search();
        for (BaseExtConfigHolder extConfig : result.foundAccessPoints()) {
            AccessPointConfigSituation situation = apConfigMapping.get(extConfig.getBasicConfig().getApId());
            if (situation == null) {
                logger.info("Initial update for AP = %d from discovery data: %s.", new Object[]{extConfig.getBasicConfig().getApId(), extConfig.toString()});
                situation = new AccessPointConfigSituation(apm, this.infoDataset, extConfig);
                apConfigMapping.put(extConfig.getBasicConfig().getApId(), situation);
                continue;
            }
            if (!situation.likelyDiscoveredAfterLastUpdate(extConfig)) continue;
            if (situation.anyDifferentFromCurrent(extConfig)) {
                if (situation.getCurrentConfig() != null) {
                    logger.info("AP = %d, current data: %s.", new Object[]{extConfig.getBasicConfig().getApId(), situation.getCurrentConfig().toString()});
                }
                logger.info("Updating AP = %d from discovery data: %s.", new Object[]{extConfig.getBasicConfig().getApId(), extConfig.toString()});
                situation.setNewCurrent(extConfig);
                continue;
            }
            situation.setCurrentDiscoveryTime(extConfig.getDiscoveryTime());
        }
    }
}

