/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.server.http.widget;

import at.mrdevelopment.esl.custom.impl.Level1Implementation;
import at.mrdevelopment.esl.persistence.DatasetException;
import at.mrdevelopment.esl.persistence.query.DatasetQuery;
import at.mrdevelopment.esl.persistence.query.QueryRestriction;
import at.mrdevelopment.esl.persistence.query.QueryResult;
import at.mrdevelopment.esl.server.http.widget.TextBasedWidget;
import at.mrdevelopment.toolkit.log.ESLLogger;

public class UpdateStatusWidget
extends TextBasedWidget {
    static ESLLogger logger = ESLLogger.getLogger(UpdateStatusWidget.class);
    private static final String WIDGET_ID = "update-status";
    private static final String WIDGET_TITLE = "Updates";
    private final Level1Implementation level1;

    public UpdateStatusWidget(Level1Implementation level1) {
        super(WIDGET_ID);
        this.level1 = level1;
    }

    @Override
    public void reload() {
        this.clearFields();
        DatasetQuery waitingQuery = this.level1.getQuery("updatestatus/waiting");
        DatasetQuery unsuccessfulQuery = this.level1.getQuery("labelinfo/unsuccessful");
        try {
            QueryResult waitingUpdates = this.level1.executeQuery(waitingQuery, QueryRestriction.newQuery((Integer)0, (Integer)1, (int)1));
            this.addField("Waiting", String.valueOf(waitingUpdates.getTotalRecords()));
            this.addUrl("Waiting", "/service/updatestatus/waiting.xml");
            QueryResult unsuccessfulUpdates = this.level1.executeQuery(unsuccessfulQuery, QueryRestriction.newQuery((Integer)0, (Integer)1, (int)1));
            this.addField("Unsuccessful", String.valueOf(unsuccessfulUpdates.getTotalRecords()));
            this.addUrl("Unsuccessful", "/service/labelinfo/unsuccessful.xml");
        }
        catch (DatasetException exc) {
            logger.warn("Could not query label information: %s", new Object[]{exc.getMessage()});
            logger.logExceptionIfDebugEnabled((Throwable)exc);
        }
    }

    @Override
    public String getWidgetTitle() {
        return WIDGET_TITLE;
    }
}

