/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.server.http.widget;

import at.mrdevelopment.esl.custom.impl.Level1Implementation;
import at.mrdevelopment.esl.persistence.DatasetException;
import at.mrdevelopment.esl.persistence.query.DatasetQuery;
import at.mrdevelopment.esl.persistence.query.QueryRestriction;
import at.mrdevelopment.esl.persistence.query.QueryResult;
import at.mrdevelopment.esl.persistence.record.LabelInfo;
import at.mrdevelopment.esl.server.http.widget.PieWidget;
import at.mrdevelopment.toolkit.log.ESLLogger;
import at.mrdevelopment.toolkit.xml.SerializeException;

public class UpdateStatusPieWidget
extends PieWidget {
    static ESLLogger logger = ESLLogger.getLogger(UpdateStatusPieWidget.class);
    private final Level1Implementation level1;

    public UpdateStatusPieWidget(Level1Implementation level1) {
        super("UpdateStatus");
        this.level1 = level1;
    }

    @Override
    public void reload() {
        this.clearValues();
        DatasetQuery labelsQuery = this.level1.getQuery("labelinfo/index");
        try {
            QueryResult allLabels = this.level1.executeQuery(labelsQuery, QueryRestriction.newUnpagedQuery());
            this.setMaxValue(allLabels.getTotalRecords());
            int unsuccessful = 0;
            int waiting = 0;
            int aborted = 0;
            int successful = 0;
            int pending = 0;
            for (LabelInfo labelInfo : allLabels.getRecords()) {
                if (labelInfo.getStatus() == null) continue;
                if (labelInfo.getStatus().isUnsuccessful()) {
                    ++unsuccessful;
                    continue;
                }
                if (labelInfo.getStatus().isWaiting()) {
                    ++waiting;
                    continue;
                }
                if (labelInfo.getStatus().isSuccessful()) {
                    ++successful;
                    continue;
                }
                if (labelInfo.getStatus().isAborted()) {
                    ++aborted;
                    continue;
                }
                if (!labelInfo.getStatus().isDelayed()) continue;
                ++pending;
            }
            this.setMaxValue(unsuccessful + waiting + aborted + successful + pending);
            this.addValue("SUCCESSFUL", successful, PieWidget.PieColor.GREEN1, "Successful updates");
            this.addValue("WAITING", waiting, PieWidget.PieColor.BLUE, "Waiting updates");
            this.addValue("UNSUCCESSFUL", unsuccessful, PieWidget.PieColor.RED, "Unsuccessful updates");
            this.addValue("ABORTED", aborted, PieWidget.PieColor.GRAY, "Aborted updates");
            this.addValue("PENDING", pending, PieWidget.PieColor.ORANGE, "Pending updates");
            try {
                this.reloadBase64String();
            }
            catch (SerializeException exception) {
                logger.warn("Could not serialize pie chart image: %s", new Object[]{exception.getMessage()});
                logger.logExceptionIfDebugEnabled((Throwable)exception);
            }
        }
        catch (DatasetException exc) {
            logger.warn("Could not query label information: %s", new Object[]{exc.getMessage()});
            logger.logExceptionIfDebugEnabled((Throwable)exc);
        }
    }

    @Override
    protected String getTitle() {
        return "Updates";
    }
}

