/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.server.http.widget;

import at.mrdevelopment.esl.server.http.widget.WidgetInterface;
import at.mrdevelopment.toolkit.xml.SerializeException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class TextBasedWidget
implements WidgetInterface {
    private final Map<String, String> fields;
    private final Map<String, String> urls;
    private final String widgetId;

    public TextBasedWidget(String widgetId) {
        this.widgetId = widgetId;
        this.fields = new LinkedHashMap<String, String>();
        this.urls = new HashMap<String, String>();
    }

    @Override
    public void toXML(Document document, Element root) throws SerializeException {
        if (this.fields.size() > 0) {
            Element textWidgetElement = document.createElement("text-widget");
            textWidgetElement.setAttribute("id", this.widgetId);
            textWidgetElement.setAttribute("title", this.getWidgetTitle());
            for (Map.Entry<String, String> entry : this.fields.entrySet()) {
                Element fieldElement = document.createElement("field");
                fieldElement.setAttribute("key", entry.getKey());
                fieldElement.setAttribute("value", entry.getValue());
                if (this.urls.containsKey(entry.getKey())) {
                    fieldElement.setAttribute("url", this.urls.get(entry.getKey()));
                }
                textWidgetElement.appendChild(fieldElement);
            }
            root.appendChild(textWidgetElement);
        }
    }

    protected void addUrl(String key, String url) {
        this.urls.put(key, url);
    }

    protected void addField(String key, String value) {
        this.fields.put(key, value);
    }

    protected void removeField(String key) {
        this.fields.remove(key);
    }

    protected void clearFields() {
        this.fields.clear();
        this.urls.clear();
    }

    protected boolean containsKey(String key) {
        return this.fields.containsKey(key);
    }

    public String getWidgetId() {
        return this.widgetId;
    }

    public int getFieldCount() {
        return this.fields.size();
    }

    public abstract String getWidgetTitle();
}

