/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.server.http.widget;

import at.mrdevelopment.esl.server.FileSystemInformationListener;
import at.mrdevelopment.esl.server.http.widget.TextBasedWidget;
import at.mrdevelopment.toolkit.log.ESLLogger;
import at.mrdevelopment.toolkit.os.FileSystem;
import at.mrdevelopment.toolkit.os.FileSystemInfo;
import at.mrdevelopment.toolkit.os.linux.LinuxHardwareInfo;
import at.mrdevelopment.toolkit.os.linux.LinuxHardwareInfoLoader;
import java.io.IOException;
import java.util.Map;

public class SystemHealthWidget
extends TextBasedWidget
implements FileSystemInformationListener {
    static ESLLogger logger = ESLLogger.getLogger(SystemHealthWidget.class);
    private static final String WIDGET_ID = "system-health";
    private static final String WIDGET_TITLE = "System Health";
    private static final int MAX_TEMPERATURE = 100;
    private FileSystemInfo fileSystemInfo;

    public SystemHealthWidget() {
        super(WIDGET_ID);
    }

    @Override
    public void reload() {
        block9: {
            this.clearFields();
            try {
                LinuxHardwareInfo hardwareInfo = LinuxHardwareInfoLoader.load();
                this.addField("CPU Usage", String.format("%s %%", String.valueOf(hardwareInfo.getAverageSystemLoad())));
                double usedPercent = (double)hardwareInfo.getUsedMemory() / (double)hardwareInfo.getTotalMemory() * 100.0;
                this.addField("Used Memory", String.format("%.2f %%", usedPercent));
                if (this.fileSystemInfo != null) {
                    for (FileSystem fs : this.fileSystemInfo.getFileSystems()) {
                        double usedFsPercent = (double)fs.getUsedSpaceInBytes() / (double)fs.getTotalSpaceInBytes() * 100.0;
                        this.addField(fs.getLabel(), String.format("%.2f %% used", usedFsPercent));
                    }
                }
                try {
                    int sumOfDegrees = 0;
                    for (Map.Entry entry : hardwareInfo.getTemperatures().entrySet()) {
                        if (!((String)entry.getValue()).endsWith(" \u00b0C")) continue;
                        Integer degrees = Integer.valueOf(((String)entry.getValue()).replaceAll(" \u00b0C", ""));
                        sumOfDegrees += degrees.intValue();
                    }
                    if (sumOfDegrees <= 0) break block9;
                    if (sumOfDegrees / hardwareInfo.getNumberOfCores() >= 100) {
                        this.addField("CPU Temperature", "Warning: Temperature critical!");
                        break block9;
                    }
                    this.addField("CPU Temperature", "Normal");
                }
                catch (NumberFormatException exc) {
                    logger.warn("Could not parse CPU temperature: %s", new Object[]{exc.getMessage()});
                    logger.logExceptionIfDebugEnabled((Throwable)exc);
                }
            }
            catch (IOException exc) {
                logger.warn("Could not load hardware info: %s", new Object[]{exc.getMessage()});
                logger.logExceptionIfDebugEnabled((Throwable)exc);
            }
            catch (InterruptedException exc) {
                logger.warn("Could not load hardware info: %s", new Object[]{exc.getMessage()});
                logger.logExceptionIfDebugEnabled((Throwable)exc);
            }
        }
    }

    @Override
    public String getWidgetTitle() {
        return WIDGET_TITLE;
    }

    @Override
    public void notifyFileSystemInformationUpdated(FileSystemInfo fileSystemInfo) {
        this.fileSystemInfo = fileSystemInfo;
    }
}

