/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.server.http.widget;

import at.mrdevelopment.esl.core.problem.QueryProblem;
import at.mrdevelopment.esl.custom.impl.Level1Implementation;
import at.mrdevelopment.esl.server.http.widget.TextBasedWidget;
import at.mrdevelopment.toolkit.authentication.UserId;
import at.mrdevelopment.toolkit.log.ESLLogger;
import at.mrdevelopment.toolkit.problem.Problem;
import java.util.Collection;

public class ProblemsWidget
extends TextBasedWidget {
    static ESLLogger logger = ESLLogger.getLogger(ProblemsWidget.class);
    private static final String WIDGET_ID = "problems";
    private final Level1Implementation level1;
    private int problemCount;

    public ProblemsWidget(Level1Implementation level1) {
        super(WIDGET_ID);
        this.level1 = level1;
    }

    @Override
    public void reload() {
        this.clearFields();
        Collection problems = this.level1.getServiceStatus(UserId.SYSTEM).getProblems();
        this.problemCount = problems.size();
        for (Problem problem : problems) {
            this.addField(problem.getMessage(), problem.getSeverity().name());
            if (!(problem instanceof QueryProblem)) continue;
            this.addUrl(problem.getMessage(), ((QueryProblem)problem).getQueryUrl() + ".xml");
        }
    }

    @Override
    public String getWidgetTitle() {
        return String.format("%d Problem(s)", this.problemCount);
    }
}

