/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.server.http.widget;

import at.mrdevelopment.esl.admin.platform.NetworkProperty;
import at.mrdevelopment.esl.network.NetworkStatus;
import at.mrdevelopment.esl.server.http.widget.TextBasedWidget;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.NetworkUtils;
import at.mrdevelopment.toolkit.log.ESLLogger;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

public class NetworkStatusWidget
extends TextBasedWidget {
    static ESLLogger logger = ESLLogger.getLogger(NetworkStatusWidget.class);
    private static final String WIDGET_ID = "network-status";
    private static final String WIDGET_TITLE = "Network Status";

    public NetworkStatusWidget() {
        super(WIDGET_ID);
    }

    @Override
    public void reload() {
        this.clearFields();
        try {
            NetworkStatus networkStatus = new NetworkStatus();
            ArrayList interfaceNames = new ArrayList(NetworkUtils.listInterfaceNames((boolean)true));
            Collections.sort(interfaceNames, new Comparator<String>(){

                @Override
                public int compare(String o1, String o2) {
                    return o1.compareTo(o2);
                }
            });
            for (String interfaceName : interfaceNames) {
                this.addField(interfaceName, "N/A");
                for (NetworkProperty networkProperty : networkStatus.getNetworkProperties()) {
                    if (!networkProperty.getAdapterName().equals(interfaceName)) continue;
                    this.addField(interfaceName, String.format("%s/%s", networkProperty.getAddress(), networkProperty.getSubnetMask()));
                }
            }
        }
        catch (IOException exc) {
            logger.warn("Could not load network status: %s", new Object[]{exc.getMessage()});
            logger.logExceptionIfDebugEnabled((Throwable)exc);
        }
        catch (InitializationException exc) {
            logger.warn("Could not load network status: %s", new Object[]{exc.getMessage()});
            logger.logExceptionIfDebugEnabled((Throwable)exc);
        }
    }

    @Override
    public String getWidgetTitle() {
        return WIDGET_TITLE;
    }
}

