/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.server.http.widget;

import at.mrdevelopment.esl.core.ConnectionStatus;
import at.mrdevelopment.esl.core.PowerStatus;
import at.mrdevelopment.esl.core.ServiceStatus;
import at.mrdevelopment.esl.custom.impl.Level1Implementation;
import at.mrdevelopment.esl.persistence.DatasetException;
import at.mrdevelopment.esl.persistence.query.DatasetQuery;
import at.mrdevelopment.esl.persistence.query.QueryRestriction;
import at.mrdevelopment.esl.persistence.query.QueryResult;
import at.mrdevelopment.esl.server.http.widget.BarWidget;
import at.mrdevelopment.toolkit.authentication.UserId;
import at.mrdevelopment.toolkit.log.ESLLogger;

public class LabelStatusBarWidget
extends BarWidget {
    static ESLLogger logger = ESLLogger.getLogger(LabelStatusBarWidget.class);
    private final Level1Implementation level1;
    private int labelCount;

    public LabelStatusBarWidget(Level1Implementation level1) {
        super("label-status");
        this.level1 = level1;
    }

    @Override
    public void reload() {
        this.clearValues();
        ServiceStatus serviceStatus = this.level1.getServiceStatus(UserId.SYSTEM);
        this.labelCount = Integer.valueOf(serviceStatus.getPropertyValue("labels"));
        this.setMaxValue(this.labelCount);
        DatasetQuery powerBadQuery = this.level1.getQuery("labelinfo/powerstatus");
        DatasetQuery errorQuery = this.level1.getQuery("labelinfo/error");
        DatasetQuery labelsWithConnectionStatusQuery = this.level1.getQuery("labelinfo/status");
        DatasetQuery labelsWithEncryptionQuery = this.level1.getQuery("labelinfo/noencryption");
        try {
            QueryResult onlineLabels = this.level1.executeQuery(labelsWithConnectionStatusQuery, QueryRestriction.newSearchQuery(ConnectionStatus.class, (Object)ConnectionStatus.ONLINE, (Integer)0, (Integer)1, (int)1));
            this.addValue("Online", onlineLabels.getTotalRecords(), BarWidget.BarColor.GREEN, "/service/labelinfo/status/online.xml?page=0");
            QueryResult offlineLabels = this.level1.executeQuery(labelsWithConnectionStatusQuery, QueryRestriction.newSearchQuery(ConnectionStatus.class, (Object)ConnectionStatus.OFFLINE, (Integer)0, (Integer)1, (int)1));
            this.addValue("Offline", offlineLabels.getTotalRecords(), BarWidget.BarColor.RED, "/service/labelinfo/status/offline.xml?page=0");
            QueryResult labelsWithErrors = this.level1.executeQuery(errorQuery, QueryRestriction.newQuery((Integer)0, (Integer)1, (int)1));
            this.addValue("Hardware Errors", labelsWithErrors.getTotalRecords(), BarWidget.BarColor.RED, "/service/labelinfo/error.xml?page=0");
            QueryResult labelsWithPowerBad = this.level1.executeQuery(powerBadQuery, QueryRestriction.newSearchQuery(PowerStatus.class, (Object)PowerStatus.BAD, (Integer)0, (Integer)1, (int)1));
            this.addValue("Power Status Bad", labelsWithPowerBad.getTotalRecords(), BarWidget.BarColor.RED, "/service/labelinfo/powerstatus/bad.xml?page=0");
            QueryResult labelsWithEncryption = this.level1.executeQuery(labelsWithEncryptionQuery, QueryRestriction.newUnpagedQuery());
            this.addValue("Unencrypted", labelsWithEncryption.getTotalRecords(), BarWidget.BarColor.ORANGE, "/service/labelinfo/noencryption.xml?page=0");
        }
        catch (DatasetException exc) {
            logger.warn("Could not query label information: %s", new Object[]{exc.getMessage()});
            logger.logExceptionIfDebugEnabled((Throwable)exc);
        }
    }

    @Override
    protected String getTitle() {
        return String.format("%d Label(s)", this.labelCount);
    }
}

