/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.server.http.widget;

import at.mrdevelopment.esl.custom.impl.Level1Implementation;
import at.mrdevelopment.esl.labelstatistics.LabelStatistics;
import at.mrdevelopment.esl.labelstatistics.StatisticCategory;
import at.mrdevelopment.esl.persistence.DatasetException;
import at.mrdevelopment.esl.persistence.query.DatasetQuery;
import at.mrdevelopment.esl.persistence.query.QueryRestriction;
import at.mrdevelopment.esl.server.http.widget.LabelStatisticsPieWidget;
import at.mrdevelopment.esl.server.http.widget.WidgetInterface;
import at.mrdevelopment.toolkit.log.ESLLogger;
import at.mrdevelopment.toolkit.xml.SerializeException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class LabelStatisticsWidgets
implements WidgetInterface {
    static ESLLogger logger = ESLLogger.getLogger(LabelStatisticsWidgets.class);
    private final Level1Implementation level1;
    private final Collection<WidgetInterface> widgets;

    public LabelStatisticsWidgets(Level1Implementation level1) {
        this.level1 = level1;
        this.widgets = new ArrayList<WidgetInterface>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reload() {
        Collection<WidgetInterface> collection = this.widgets;
        synchronized (collection) {
            this.widgets.clear();
            List<LabelStatistics> labelStatisticsList = this.getLabelStatistics();
            this.widgets.add(new LabelStatisticsPieWidget(labelStatisticsList, StatisticCategory.CONNECTION_STATUS));
            this.widgets.add(new LabelStatisticsPieWidget(labelStatisticsList, StatisticCategory.BATTERY_STATUS));
            this.widgets.add(new LabelStatisticsPieWidget(labelStatisticsList, StatisticCategory.SYNC_QUALITY));
            this.widgets.add(new LabelStatisticsPieWidget(labelStatisticsList, StatisticCategory.RSSI));
            this.widgets.add(new LabelStatisticsPieWidget(labelStatisticsList, StatisticCategory.LQI));
            this.widgets.add(new LabelStatisticsPieWidget(labelStatisticsList, StatisticCategory.HARDWARE_ERRORS));
            this.widgets.add(new LabelStatisticsPieWidget(labelStatisticsList, StatisticCategory.ENCRYPTION_STATUS));
            for (WidgetInterface widget : this.widgets) {
                widget.reload();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void toXML(Document document, Element root) throws SerializeException {
        Collection<WidgetInterface> collection = this.widgets;
        synchronized (collection) {
            for (WidgetInterface widget : this.widgets) {
                widget.toXML(document, root);
            }
        }
    }

    private List<LabelStatistics> getLabelStatistics() {
        List labelStatisticsList = null;
        DatasetQuery query = this.level1.getQuery("labelinfo/statistics");
        try {
            labelStatisticsList = this.level1.executeQuery(query, QueryRestriction.newUnpagedQuery()).getRecords();
        }
        catch (DatasetException exception) {
            logger.warn("Could not query label information: %s", new Object[]{exception.getMessage()});
            logger.logExceptionIfDebugEnabled((Throwable)exception);
        }
        return labelStatisticsList;
    }
}

