/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.server.http.widget;

import at.mrdevelopment.esl.core.ConnectionStatus;
import at.mrdevelopment.esl.core.LinkQuality;
import at.mrdevelopment.esl.core.PowerStatus;
import at.mrdevelopment.esl.core.SecurityStatus;
import at.mrdevelopment.esl.labelstatistics.HardwareErrorsLabelInfo;
import at.mrdevelopment.esl.labelstatistics.LabelStatistics;
import at.mrdevelopment.esl.labelstatistics.LqiLabelInfo;
import at.mrdevelopment.esl.labelstatistics.RssiLabelInfo;
import at.mrdevelopment.esl.labelstatistics.StatisticCategory;
import at.mrdevelopment.esl.server.http.widget.PieWidget;
import at.mrdevelopment.toolkit.log.ESLLogger;
import at.mrdevelopment.toolkit.xml.SerializeException;
import java.util.List;

public class LabelStatisticsPieWidget
extends PieWidget {
    static ESLLogger logger = ESLLogger.getLogger(LabelStatisticsPieWidget.class);
    private final List<LabelStatistics> labelStatisticsList;
    private final StatisticCategory statisticCategory;

    public LabelStatisticsPieWidget(List<LabelStatistics> labelStatistics, StatisticCategory statisticCategory) {
        super(statisticCategory.getIdentifier());
        this.labelStatisticsList = labelStatistics;
        this.statisticCategory = statisticCategory;
    }

    @Override
    public void reload() {
        this.clearValues();
        this.setMaxValue(this.labelStatisticsList.get(0).getTotalLabels());
        for (LabelStatistics labelStatistics : this.labelStatisticsList) {
            if (!labelStatistics.getCategory().equals((Object)this.statisticCategory)) continue;
            this.addValue(labelStatistics.getIdentifier(), labelStatistics.getCount(), this.getSliceColor(labelStatistics), labelStatistics.getDescription());
        }
        try {
            this.reloadBase64String();
        }
        catch (SerializeException exception) {
            logger.warn("Could not serialize pie chart image: %s", new Object[]{exception.getMessage()});
            logger.logExceptionIfDebugEnabled((Throwable)exception);
        }
    }

    @Override
    protected String getTitle() {
        return this.statisticCategory.getDescription();
    }

    private PieWidget.PieColor getSliceColor(LabelStatistics labelStatistics) {
        StatisticCategory category = labelStatistics.getCategory();
        String identifier = labelStatistics.getIdentifier();
        if (category.equals((Object)StatisticCategory.CONNECTION_STATUS) && identifier.equals(ConnectionStatus.ONLINE.toString()) || category.equals((Object)StatisticCategory.BATTERY_STATUS) && identifier.equals(PowerStatus.GOOD.toString()) || category.equals((Object)StatisticCategory.SYNC_QUALITY) && identifier.equals(LinkQuality.PERFECT.toString()) || category.equals((Object)StatisticCategory.RSSI) && identifier.equals(RssiLabelInfo.RSSI.CLASS_A.getIdentifier()) || category.equals((Object)StatisticCategory.LQI) && identifier.equals(LqiLabelInfo.LQI.GOOD.getIdentifier()) || category.equals((Object)StatisticCategory.HARDWARE_ERRORS) && identifier.equals(HardwareErrorsLabelInfo.HardwareErrors.HAS_NO_HARDWARE_ERRORS.getIdentifier()) || category.equals((Object)StatisticCategory.ENCRYPTION_STATUS) && identifier.equals(SecurityStatus.AES128.toString())) {
            return PieWidget.PieColor.GREEN1;
        }
        if (category.equals((Object)StatisticCategory.CONNECTION_STATUS) && identifier.equals(ConnectionStatus.OFFLINE.toString()) || category.equals((Object)StatisticCategory.BATTERY_STATUS) && identifier.equals(PowerStatus.BAD.toString()) || category.equals((Object)StatisticCategory.SYNC_QUALITY) && identifier.equals(LinkQuality.BAD.toString()) || category.equals((Object)StatisticCategory.RSSI) && identifier.equals(RssiLabelInfo.RSSI.CLASS_G.getIdentifier()) || category.equals((Object)StatisticCategory.LQI) && identifier.equals(LqiLabelInfo.LQI.BAD.getIdentifier()) || category.equals((Object)StatisticCategory.HARDWARE_ERRORS) && identifier.equals(HardwareErrorsLabelInfo.HardwareErrors.HAS_HARDWARE_ERRORS.getIdentifier()) || category.equals((Object)StatisticCategory.ENCRYPTION_STATUS) && identifier.equals(SecurityStatus.NO_PIN.toString())) {
            return PieWidget.PieColor.RED;
        }
        if (category.equals((Object)StatisticCategory.CONNECTION_STATUS) && identifier.equals(ConnectionStatus.DISCOVERED.toString()) || category.equals((Object)StatisticCategory.ENCRYPTION_STATUS) && identifier.equals(SecurityStatus.KEY_UNSET.toString())) {
            return PieWidget.PieColor.BLUE;
        }
        if (category.equals((Object)StatisticCategory.BATTERY_STATUS) && identifier.equals(PowerStatus.LOW.toString()) || category.equals((Object)StatisticCategory.SYNC_QUALITY) && identifier.equals(LinkQuality.AVERAGE.toString()) || category.equals((Object)StatisticCategory.RSSI) && identifier.equals(RssiLabelInfo.RSSI.CLASS_F.getIdentifier()) || category.equals((Object)StatisticCategory.ENCRYPTION_STATUS) && identifier.equals(SecurityStatus.UNSUPPORTED.toString())) {
            return PieWidget.PieColor.ORANGE;
        }
        if (category.equals((Object)StatisticCategory.SYNC_QUALITY) && identifier.equals(LinkQuality.GOOD.toString()) || category.equals((Object)StatisticCategory.RSSI) && identifier.equals(RssiLabelInfo.RSSI.CLASS_B.getIdentifier())) {
            return PieWidget.PieColor.GREEN2;
        }
        if (category.equals((Object)StatisticCategory.RSSI) && identifier.equals(RssiLabelInfo.RSSI.CLASS_C.getIdentifier())) {
            return PieWidget.PieColor.GREEN3;
        }
        if (category.equals((Object)StatisticCategory.RSSI) && identifier.equals(RssiLabelInfo.RSSI.CLASS_D.getIdentifier())) {
            return PieWidget.PieColor.GREEN4;
        }
        if (category.equals((Object)StatisticCategory.RSSI) && identifier.equals(RssiLabelInfo.RSSI.CLASS_E.getIdentifier())) {
            return PieWidget.PieColor.GREEN5;
        }
        if (category.equals((Object)StatisticCategory.CONNECTION_STATUS) && identifier.equals(ConnectionStatus.UNKNOWN.toString()) || category.equals((Object)StatisticCategory.BATTERY_STATUS) && identifier.equals(PowerStatus.UNKNOWN.toString()) || category.equals((Object)StatisticCategory.SYNC_QUALITY) && identifier.equals("UNKNOWN") || category.equals((Object)StatisticCategory.RSSI) && identifier.equals(RssiLabelInfo.RSSI.UNKNOWN.getIdentifier()) || category.equals((Object)StatisticCategory.LQI) && identifier.equals(LqiLabelInfo.LQI.UNKNOWN.getIdentifier()) || category.equals((Object)StatisticCategory.HARDWARE_ERRORS) && identifier.equals(HardwareErrorsLabelInfo.HardwareErrors.UNKNOWN.getIdentifier()) || category.equals((Object)StatisticCategory.ENCRYPTION_STATUS) && identifier.equals(SecurityStatus.UNKNOWN.toString()) || category.equals((Object)StatisticCategory.LABEL_DISTRIBUTION) && identifier.equals("UNKNOWN")) {
            return PieWidget.PieColor.GRAY;
        }
        return null;
    }
}

