/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.server.http.widget;

import at.mrdevelopment.esl.custom.impl.Level1Implementation;
import at.mrdevelopment.esl.persistence.DatasetException;
import at.mrdevelopment.esl.persistence.query.DatasetQuery;
import at.mrdevelopment.esl.persistence.query.QueryRestriction;
import at.mrdevelopment.esl.persistence.query.QueryResult;
import at.mrdevelopment.esl.persistence.record.AccessPointInfo;
import at.mrdevelopment.esl.server.http.widget.TextBasedWidget;
import at.mrdevelopment.toolkit.log.ESLLogger;
import java.util.List;

public class AccessPointStatusWidget
extends TextBasedWidget {
    static ESLLogger logger = ESLLogger.getLogger(AccessPointStatusWidget.class);
    private static final String WIDGET_ID = "accesspoints";
    private final Level1Implementation level1;

    public AccessPointStatusWidget(Level1Implementation level1) {
        super(WIDGET_ID);
        this.level1 = level1;
    }

    @Override
    public void reload() {
        this.clearFields();
        DatasetQuery query = this.level1.getQuery("accesspointinfo/index");
        try {
            QueryResult result = this.level1.executeQuery(query, QueryRestriction.newUnpagedQuery());
            List accessPoints = result.getRecords();
            for (AccessPointInfo accessPoint : accessPoints) {
                if (accessPoint.isDiscovered()) continue;
                this.addField(String.valueOf(accessPoint.getAccessPointId()), accessPoint.getConnectionStatus().name());
                this.addUrl(String.valueOf(accessPoint.getAccessPointId()), accessPoint.getAddress());
            }
        }
        catch (DatasetException exc) {
            logger.warn("Could not load access point infos: %s", new Object[]{exc.getMessage()});
            logger.logExceptionIfDebugEnabled((Throwable)exc);
        }
    }

    @Override
    public String getWidgetTitle() {
        return String.format("%d Access Point(s)", this.getFieldCount());
    }
}

