/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.server.http;

import at.mrdevelopment.esl.custom.level1.Level1Interface;
import at.mrdevelopment.esl.persistence.RecordXMLSerializer;
import at.mrdevelopment.esl.persistence.annotation.Serialize;
import at.mrdevelopment.esl.persistence.query.DatasetQuery;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.http.HttpRequestMethod;
import at.mrdevelopment.toolkit.http.Route;
import at.mrdevelopment.toolkit.http.WebserviceRequest;
import at.mrdevelopment.toolkit.http.WebserviceRequestHandler;
import at.mrdevelopment.toolkit.http.WebserviceResponse;
import at.mrdevelopment.toolkit.xml.SerializeException;
import java.util.ArrayList;
import java.util.Collection;
import org.w3c.dom.Document;

@Route(route="/service/queries")
public class QuerySummaryRequestHandler
implements WebserviceRequestHandler {
    private final Level1Interface level1;
    private final RecordXMLSerializer<Query> querySerializer;

    public QuerySummaryRequestHandler(Level1Interface level1) throws InitializationException {
        this.level1 = level1;
        this.querySerializer = new RecordXMLSerializer(Query.class);
    }

    @Route(method=HttpRequestMethod.GET, route="index.xml")
    public void getQueries(WebserviceRequest request, WebserviceResponse response) throws SerializeException {
        Collection<DatasetQuery<?, ?>> queries = this.level1.getQueries();
        ArrayList<Query> queryInfos = new ArrayList<Query>(queries.size());
        for (DatasetQuery<?, ?> query : queries) {
            queryInfos.add(new Query(query));
        }
        Document document = this.querySerializer.toXML(queryInfos);
        response.respondDocument(document, request.isGzipEncodingAccepted());
    }

    public String getRouteFromPattern(String route) {
        return route;
    }

    public static class Query {
        private final String url;
        private final String recordClass;
        private final String parameterClass;
        private final boolean singleRecordExpected;

        public Query(DatasetQuery<?, ?> query) {
            this.url = query.getUrl();
            this.recordClass = query.getRecordClass().getSimpleName();
            this.parameterClass = query.getParameterClass().getSimpleName();
            this.singleRecordExpected = query.isSingleRecordExpected();
        }

        @Serialize
        public String getUrl() {
            return this.url;
        }

        @Serialize
        public String getRecordClass() {
            return this.recordClass;
        }

        @Serialize
        public String getParameterClass() {
            return this.parameterClass;
        }

        @Serialize
        public boolean isSingleRecordExpected() {
            return this.singleRecordExpected;
        }
    }
}

