/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.server.http;

import at.mrdevelopment.esl.authentication.UserAuthenticator;
import at.mrdevelopment.esl.custom.level1.Level1Interface;
import at.mrdevelopment.esl.persistence.DatasetException;
import at.mrdevelopment.esl.persistence.dataset.UserDataset;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.authentication.Authenticator;
import at.mrdevelopment.toolkit.http.Authentication;
import at.mrdevelopment.toolkit.http.BasicAuthentication;
import at.mrdevelopment.toolkit.http.BasicHttpRequestHandler;
import at.mrdevelopment.toolkit.http.BasicHttpServer;
import at.mrdevelopment.toolkit.http.BlockedRequestHandler;
import at.mrdevelopment.toolkit.http.WebserviceRequestHandler;
import at.mrdevelopment.toolkit.xml.ExceptionXMLSerializer;

public class ESLServiceHttpServer
extends BasicHttpServer {
    private final ExceptionXMLSerializer exceptionXMLSerializer;
    private final Authentication authentication;
    private final String stylesheet;
    private final BlockedRequestHandler blockedRequestHandler;

    public ESLServiceHttpServer(Level1Interface level1, UserDataset userDataset, String stylesheet, BlockedRequestHandler blockedRequestHandler) throws DatasetException, InitializationException {
        this.stylesheet = stylesheet;
        this.blockedRequestHandler = blockedRequestHandler;
        UserAuthenticator authenticator = new UserAuthenticator(level1.getTransactionSupplier(), userDataset);
        this.authentication = new BasicAuthentication((Authenticator)authenticator, "SES-imagotag Core Service");
        this.exceptionXMLSerializer = new ExceptionXMLSerializer();
    }

    public void register(WebserviceRequestHandler handler) {
        super.register(new BasicHttpRequestHandler(handler, this.stylesheet, this.authentication, this.exceptionXMLSerializer, this.blockedRequestHandler));
    }

    public void register(WebserviceRequestHandler handler, Authentication authentication) {
        super.register(new BasicHttpRequestHandler(handler, this.stylesheet, authentication, this.exceptionXMLSerializer, this.blockedRequestHandler));
    }

    public void register(WebserviceRequestHandler handler, String customStylesheet) {
        super.register(new BasicHttpRequestHandler(handler, customStylesheet, this.authentication, this.exceptionXMLSerializer, this.blockedRequestHandler));
    }
}

