/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.server.http;

import at.mrdevelopment.esl.persistence.DatasetException;
import at.mrdevelopment.esl.persistence.RecordUtils;
import at.mrdevelopment.esl.persistence.RecordXMLSerializer;
import at.mrdevelopment.esl.persistence.dataset.Dataset;
import at.mrdevelopment.esl.persistence.dataset.Transaction;
import at.mrdevelopment.esl.persistence.dataset.TransactionSupplier;
import at.mrdevelopment.esl.persistence.record.Commit;
import at.mrdevelopment.esl.persistence.record.Commitable;
import at.mrdevelopment.esl.persistence.record.Id;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.http.HttpRequestMethod;
import at.mrdevelopment.toolkit.http.Route;
import at.mrdevelopment.toolkit.http.WebserviceRequest;
import at.mrdevelopment.toolkit.http.WebserviceRequestHandler;
import at.mrdevelopment.toolkit.http.WebserviceResponse;
import at.mrdevelopment.toolkit.log.ESLLogger;
import at.mrdevelopment.toolkit.xml.SerializeException;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.w3c.dom.Document;

@Route(route="/service")
public class DatasetWebserviceRequestHandler<T extends Commitable>
implements WebserviceRequestHandler {
    static ESLLogger logger = ESLLogger.getLogger(DatasetWebserviceRequestHandler.class);
    private final Dataset<T> dataset;
    private final RecordXMLSerializer<T> recordSerializer;
    private final RecordXMLSerializer<Commit> commitSerializer;
    private final RecordXMLSerializer<Id> idSerializer;
    private final TransactionSupplier transactionSupplier;

    public DatasetWebserviceRequestHandler(TransactionSupplier transactionSupplier, Dataset<T> dataset) throws InitializationException {
        this.transactionSupplier = transactionSupplier;
        this.dataset = dataset;
        this.recordSerializer = new RecordXMLSerializer(dataset.getRecordClass(), dataset.getCustomFields());
        this.commitSerializer = new RecordXMLSerializer(Commit.class);
        this.idSerializer = new RecordXMLSerializer(Id.class);
    }

    @Route(method=HttpRequestMethod.GET, route=":type/:key.xml", pattern="[0-9]+")
    public void getRecordById(WebserviceRequest request, WebserviceResponse response) throws DatasetException, SerializeException {
        long id = Long.parseLong(request.getUrlBaseName());
        Commitable record = null;
        Transaction transaction = this.transactionSupplier.newTransaction();
        try {
            record = this.dataset.queryById(id, transaction);
            transaction.commit();
        }
        catch (Exception exc) {
            transaction.rollback();
            throw new DatasetException((Throwable)exc);
        }
        if (record != null) {
            Document document = this.recordSerializer.toXML((Object)record);
            response.respondDocument(document, request.isGzipEncodingAccepted());
        } else {
            response.respondFileNotFound(String.format("Record with ID %d not found", id));
        }
    }

    @Route(method=HttpRequestMethod.POST, route=":type/store.xml")
    public void storeRecords(WebserviceRequest request, WebserviceResponse response) throws IllegalStateException, IOException, SerializeException, DatasetException {
        List records = this.recordSerializer.parseXML(request.getBody().getContent());
        Transaction transaction = this.transactionSupplier.newTransaction();
        try {
            this.dataset.store((Collection)records, request.getUser(), transaction);
            transaction.commit();
        }
        catch (Exception exc) {
            transaction.rollback();
            throw new DatasetException((Throwable)exc);
        }
        Collection commits = RecordUtils.toCommits((Collection)records);
        Document document = this.commitSerializer.toXML(commits);
        response.respondDocument(document, request.isGzipEncodingAccepted());
    }

    @Route(method=HttpRequestMethod.POST, route=":type/delete.xml")
    public void deleteRecords(WebserviceRequest request, WebserviceResponse response) throws SerializeException, DatasetException, IllegalStateException, IOException {
        List recordIdsToDelete = this.idSerializer.parseXML(request.getBody().getContent());
        Collection records = null;
        Transaction transaction = this.transactionSupplier.newTransaction();
        try {
            records = RecordUtils.toRecords((Collection)recordIdsToDelete, this.dataset, (Transaction)transaction);
            this.dataset.delete(records, request.getUser(), transaction);
            transaction.commit();
        }
        catch (Exception exc) {
            transaction.rollback();
            throw new DatasetException((Throwable)exc);
        }
        Collection commits = RecordUtils.toCommits((Collection)records);
        Document document = this.commitSerializer.toXML(commits);
        response.respondDocument(document, request.isGzipEncodingAccepted());
    }

    public String getRouteFromPattern(String urlPattern) {
        urlPattern = urlPattern.replace(":type", this.dataset.getRecordClass().getSimpleName().toLowerCase());
        return urlPattern;
    }
}

