/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.server.http;

import at.mrdevelopment.esl.persistence.RecordXMLSerializer;
import at.mrdevelopment.esl.persistence.dataset.ORMDataset;
import at.mrdevelopment.esl.persistence.dataset.Transaction;
import at.mrdevelopment.esl.persistence.query.DatasetQuery;
import at.mrdevelopment.esl.persistence.query.QueryRestriction;
import at.mrdevelopment.esl.persistence.query.QueryResult;
import at.mrdevelopment.esl.server.http.DatasetQueryWebserviceRequestHandler;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.http.HttpRequestMethod;
import at.mrdevelopment.toolkit.http.Route;
import at.mrdevelopment.toolkit.http.WebserviceRequest;
import at.mrdevelopment.toolkit.http.WebserviceRequestHandler;
import at.mrdevelopment.toolkit.http.WebserviceResponse;
import at.mrdevelopment.toolkit.log.ESLLogger;
import at.mrdevelopment.toolkit.xml.SerializeException;
import org.hibernate.SessionFactory;
import org.w3c.dom.Document;

public abstract class BaseDatasetQueryWebserviceRequestHandler<T, S>
implements WebserviceRequestHandler {
    static ESLLogger logger = ESLLogger.getLogger(DatasetQueryWebserviceRequestHandler.class);
    private final DatasetQuery<T, S> query;
    private SessionFactory sessionFactory;
    protected final RecordXMLSerializer<T> recordSerializer;

    public BaseDatasetQueryWebserviceRequestHandler(DatasetQuery<T, S> query, SessionFactory sessionFactory) throws InitializationException {
        this.query = query;
        this.sessionFactory = sessionFactory;
        this.recordSerializer = new RecordXMLSerializer(query.getRecordClass(), query.isSingleRecordExpected(), query.getCustomFields());
    }

    @Route(method=HttpRequestMethod.GET, route=":query.xml")
    public void queryRecords(WebserviceRequest request, WebserviceResponse response) throws Exception {
        Transaction<?> transaction = ORMDataset.newReadUncommittedTransactionFromSessionFactory(this.sessionFactory);
        try {
            QueryRestriction<S> queryRestriction = this.getQueryRestriction(request);
            QueryResult result = this.query.getResult(queryRestriction, transaction);
            if (this.query.isSingleRecordExpected() && result.getTotalRecords() > 1) {
                throw new SerializeException("Expected single record but query returned %d records", new Object[]{result.getTotalRecords()});
            }
            if (this.query.isSingleRecordExpected() && result.getTotalRecords() == 0) {
                response.respondFileNotFound("Record not found");
            } else {
                Document document = this.recordSerializer.toXML(result);
                response.respondDocument(document, request.isGzipEncodingAccepted());
            }
            transaction.commit();
        }
        catch (Exception exc) {
            transaction.rollback();
            throw exc;
        }
    }

    @Route(method=HttpRequestMethod.GET, route=":query/count.xml")
    public void queryCount(WebserviceRequest request, WebserviceResponse response) throws Exception {
        Transaction<?> transaction = ORMDataset.newTransactionFromSessionFactory(this.sessionFactory);
        try {
            QueryRestriction<S> queryRestriction = this.getQueryRestriction(request);
            int count = this.query.getCount(queryRestriction, transaction);
            Document document = this.recordSerializer.toXML(count);
            response.respondDocument(document, request.isGzipEncodingAccepted());
            transaction.commit();
        }
        catch (Exception exc) {
            transaction.rollback();
            throw exc;
        }
    }

    public String getRouteFromPattern(String urlPattern) {
        urlPattern = urlPattern.replace(":query", this.query.getUrl());
        urlPattern = urlPattern.replace(":type", this.query.getRecordClass().getSimpleName().toLowerCase());
        return urlPattern;
    }

    protected abstract QueryRestriction<S> getQueryRestriction(WebserviceRequest var1) throws SerializeException;

    protected Integer getPage(WebserviceRequest request) throws NumberFormatException {
        String page = (String)request.getRequestParameters().get("page");
        return page != null ? Integer.valueOf(Integer.parseInt(page)) : null;
    }

    protected Integer getRecordsPerPage(WebserviceRequest request) throws NumberFormatException {
        String recordsPerPage = (String)request.getRequestParameters().get("recordsPerPage");
        return recordsPerPage != null ? Integer.valueOf(Integer.parseInt(recordsPerPage)) : null;
    }
}

