/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.server.data;

import at.mrdevelopment.esl.admin.platform.config.storage.PlatformStorage;
import at.mrdevelopment.esl.server.data.DataImporter;
import at.mrdevelopment.esl.server.data.GenericZipEntry;
import at.mrdevelopment.esl.server.data.ZipPackage;
import at.mrdevelopment.toolkit.StreamUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Collection;

public abstract class GenericImport
implements DataImporter {
    protected ClassLoader classLoader = null;
    protected PlatformStorage platformStorage = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void importData(File file) throws Exception {
        if (file != null && file.exists()) {
            FileInputStream inputStream = null;
            try {
                inputStream = new FileInputStream(file);
                this.parseEntries(true, inputStream);
            }
            catch (Throwable throwable) {
                StreamUtils.close(inputStream);
                throw throwable;
            }
            StreamUtils.close((InputStream)inputStream);
        }
    }

    public void parseEntries(boolean clear, InputStream inputStream) throws Exception {
        this.importEntries(clear, ZipPackage.readArchive(inputStream, this.platformStorage, this.classLoader));
    }

    public abstract void importEntries(boolean var1, Collection<GenericZipEntry<?>> var2) throws Exception;

    @Override
    public void setPlatformStorage(PlatformStorage platformStorage) {
        this.platformStorage = platformStorage;
    }

    @Override
    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }
}

