/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.server.data;

import at.mrdevelopment.esl.admin.platform.config.storage.PlatformStorage;
import at.mrdevelopment.esl.server.data.ESLDatabaseIdList;
import at.mrdevelopment.esl.server.data.GenericImport;
import at.mrdevelopment.esl.server.data.GenericZipEntry;
import at.mrdevelopment.esl.server.data.ZipPackage;
import java.io.InputStream;
import java.util.Collection;
import java.util.UUID;

public class DatabaseIdImporter
extends GenericImport {
    private UUID databaseId = null;

    public DatabaseIdImporter(ClassLoader classLoader, PlatformStorage platformStorage) {
        this.setClassLoader(classLoader);
        this.setPlatformStorage(platformStorage);
    }

    @Override
    public void importEntries(boolean clear, Collection<GenericZipEntry<?>> entries) throws Exception {
        for (GenericZipEntry<?> entry : entries) {
            ESLDatabaseIdList list;
            if (!entry.getRecordClass().equals(ESLDatabaseIdList.class) || (list = (ESLDatabaseIdList)entry.getRecord()) == null || list.List == null || list.List.isEmpty()) continue;
            this.databaseId = UUID.fromString(list.List.iterator().next().id);
        }
    }

    @Override
    public void parseEntries(boolean clear, InputStream inputStream) throws Exception {
        this.importEntries(clear, ZipPackage.readArchive(inputStream, this.platformStorage, this.classLoader));
    }

    public UUID getDatabaseId() {
        return this.databaseId;
    }
}

