/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.server;

import at.mrdevelopment.esl.configuration.Config;
import at.mrdevelopment.esl.core.DefaultPeriodicTasksExecutor;
import at.mrdevelopment.esl.core.ESLProcessingTask;
import at.mrdevelopment.esl.core.LabelId;
import at.mrdevelopment.esl.core.UpdateCreationException;
import at.mrdevelopment.esl.core.labeltype.LabelType;
import at.mrdevelopment.esl.core.security.Pin;
import at.mrdevelopment.esl.licencing.FeatureUnlock;
import at.mrdevelopment.esl.persistence.DatasetException;
import at.mrdevelopment.esl.persistence.dataset.LabelActivePageDataset;
import at.mrdevelopment.esl.persistence.dataset.LabelInfoDataset;
import at.mrdevelopment.esl.persistence.dataset.LabelPageContentDataset;
import at.mrdevelopment.esl.persistence.dataset.Transaction;
import at.mrdevelopment.esl.persistence.dataset.TransactionSupplier;
import at.mrdevelopment.esl.persistence.transaction.BatchUpdateTransactionSupplier;
import at.mrdevelopment.esl.persistence.transaction.ORMTransaction;
import at.mrdevelopment.esl.server.AccessPointCommunication;
import at.mrdevelopment.esl.server.DelayedTaskProcessing;
import at.mrdevelopment.esl.server.ScheduledAbortRequestProcessing;
import at.mrdevelopment.esl.server.UpdateStatusUpdater;
import at.mrdevelopment.esl.server.WaitingTaskCache;
import at.mrdevelopment.esl.tasks.ExecutableTask;
import at.mrdevelopment.esl.tasks.RegisterLabelTask;
import at.mrdevelopment.esl.tasks.TaskType;
import at.mrdevelopment.esl.tasks.UpdateStatusFactory;
import at.mrdevelopment.esl.type.UpdateError;
import at.mrdevelopment.esl.type.WakeupStatistic;
import at.mrdevelopment.esl.update.Update;
import at.mrdevelopment.esl.updatetask.ExternalUpdateTask;
import at.mrdevelopment.esl.updatetask.TaskPriority;
import at.mrdevelopment.esl.updatetask.UpdateTaskFactory;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.authentication.UserId;
import at.mrdevelopment.toolkit.log.ESLLogger;
import at.mrdevelopment.toolkit.xml.SerializeException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.UUID;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;

public class WaitingTaskProcessing
extends DefaultPeriodicTasksExecutor {
    private static final int MAX_UPDATE_BATCH_SIZE = 100;
    static ESLLogger logger = ESLLogger.getLogger(WaitingTaskProcessing.class);
    private final UpdateStatusFactory updateStatusFactory;
    private final UpdateTaskFactory updateTaskFactory;
    private final UpdateStatusUpdater updateStatusUpdater;
    private final AccessPointCommunication accessPointCommunication;
    private final WaitingTaskCache waitingTaskCache;
    private final FeatureUnlock featureUnlock;
    private final LabelInfoDataset labelInfoDataset;
    private final TransactionSupplier transactionSupplier;
    private final ScheduledAbortRequestProcessing scheduledAbortRequestProcessing;
    private final DelayedTaskProcessing delayedTaskProcessing;
    private final Map<Integer, PriorityQueue<PreassignedEntry>> preassignedTasksQueue = new HashMap<Integer, PriorityQueue<PreassignedEntry>>();
    private final Collection<Update> unassignableTasks = new ArrayList<Update>();

    public WaitingTaskProcessing(UpdateStatusFactory updateStatusFactory, UpdateTaskFactory updateTaskFactory, UpdateStatusUpdater updateStatusUpdater, AccessPointCommunication accessPointCommunication, WaitingTaskCache waitingTaskCache, FeatureUnlock featureUnlock, LabelInfoDataset labelInfoDataset, TransactionSupplier transactionSupplier, LabelPageContentDataset labelPageContentDataset, LabelActivePageDataset labelActivePageDataset, ScheduledAbortRequestProcessing scheduledAbortRequestProcessing) throws InitializationException {
        super(false);
        this.updateStatusFactory = updateStatusFactory;
        this.updateTaskFactory = updateTaskFactory;
        this.updateStatusUpdater = updateStatusUpdater;
        this.accessPointCommunication = accessPointCommunication;
        this.waitingTaskCache = waitingTaskCache;
        this.featureUnlock = featureUnlock;
        this.labelInfoDataset = labelInfoDataset;
        this.transactionSupplier = transactionSupplier;
        this.scheduledAbortRequestProcessing = scheduledAbortRequestProcessing;
        this.delayedTaskProcessing = new DelayedTaskProcessing(updateStatusUpdater, labelPageContentDataset, labelActivePageDataset);
        this.createProcessingTasks();
    }

    private void createProcessingTasks() throws InitializationException {
        this.addProcessingTask(new ESLProcessingTask(){

            public void run() throws Exception {
                logger.debug("Wait for tasks (delayed or waiting)");
                WaitingTaskProcessing.this.waitingTaskCache.waitForTasks(Config.getServerReloadSleepTimeInSeconds());
            }
        });
        this.addProcessingTask(new ESLProcessingTask(){

            public void run() throws Exception {
                logger.debug("Processing delayed task");
                ORMTransaction transaction = BatchUpdateTransactionSupplier.fromTransactionSupplier(WaitingTaskProcessing.this.transactionSupplier, 100).newTransaction();
                try {
                    WaitingTaskProcessing.this.processDelayedTasks(transaction);
                    transaction.commit();
                }
                catch (Exception exc) {
                    transaction.rollback();
                    throw exc;
                }
            }
        });
        this.addProcessingTask(new ESLProcessingTask(){

            public void run() throws Exception {
                logger.debug("Processing waiting tasks and assigning updates to access points");
                ORMTransaction transaction = BatchUpdateTransactionSupplier.fromTransactionSupplier(WaitingTaskProcessing.this.transactionSupplier, 100).newTransaction();
                try {
                    WaitingTaskProcessing.this.processUnassignedWaitingTasks(transaction);
                    transaction.commit();
                }
                catch (Exception exc) {
                    transaction.rollback();
                    throw exc;
                }
            }
        });
        this.addProcessingTask(new ESLProcessingTask(){

            public void run() throws Exception {
                logger.debug("Timing out unassigned tasks");
                ORMTransaction transaction = BatchUpdateTransactionSupplier.fromTransactionSupplier(WaitingTaskProcessing.this.transactionSupplier, 100).newTransaction();
                try {
                    WaitingTaskProcessing.this.timeoutUnassignedTasks(transaction);
                    transaction.commit();
                }
                catch (Exception exc) {
                    transaction.rollback();
                    throw exc;
                }
            }
        });
        this.addProcessingTask(new ESLProcessingTask(){

            public void run() throws Exception {
                logger.debug("Processing update tasks received from all access points");
                ORMTransaction transaction = BatchUpdateTransactionSupplier.fromTransactionSupplier(WaitingTaskProcessing.this.transactionSupplier, 100).newTransaction();
                try {
                    WaitingTaskProcessing.this.processUpdateTasksFromAccessPoints(transaction);
                    if (!transaction.isCommitted()) {
                        transaction.commit();
                    }
                }
                catch (Exception exc) {
                    transaction.rollback();
                    throw exc;
                }
            }
        });
        this.addProcessingTask(new ESLProcessingTask(){

            public void run() throws Exception {
                logger.debug("Timing out assigned tasks (updates lost or no progress)");
                ORMTransaction transaction = BatchUpdateTransactionSupplier.fromTransactionSupplier(WaitingTaskProcessing.this.transactionSupplier, 100).newTransaction();
                try {
                    WaitingTaskProcessing.this.timeoutAssignedTasks(transaction);
                    transaction.commit();
                }
                catch (Exception exc) {
                    transaction.rollback();
                    throw exc;
                }
            }
        });
        this.addProcessingTask(new ESLProcessingTask(){

            public void run() throws DatasetException {
                logger.debug("Label connection status is UNKNOWN if there are assigned tasks");
                WaitingTaskProcessing.this.showConnectionStatusAsUnknownDuringTransmission();
            }
        });
        this.addProcessingTask(new ESLProcessingTask(){

            public void run() throws Exception {
                logger.debug("Processing abort requests");
                WaitingTaskProcessing.this.scheduledAbortRequestProcessing.processAbortRequests();
            }
        });
    }

    private void processDelayedTasks(Transaction<?> transaction) throws DatasetException {
        Collection<LabelId> labelsWithWaitingOrDelayedTasks = this.waitingTaskCache.getLabelsWithWaitingOrDelayedTasks();
        for (LabelId labelId : labelsWithWaitingOrDelayedTasks) {
            Collection<Update> waitingOrDelayedUpdates = this.waitingTaskCache.getWaitingAndDelayedTasksForLabel(labelId);
            this.delayedTaskProcessing.processUpdates(waitingOrDelayedUpdates, transaction);
        }
    }

    private void processUnassignedWaitingTasks(Transaction<?> transaction) throws DatasetException, SerializeException, InterruptedException {
        Collection<Update> unassignedWaitingTasks = this.waitingTaskCache.getUnassignedTasks();
        if (unassignedWaitingTasks.size() > 0) {
            logger.info("Processing %d unassigned waiting tasks", new Object[]{unassignedWaitingTasks.size()});
            for (Update update : unassignedWaitingTasks) {
                this.processUnassignedWaitingTask(update, transaction);
            }
            this.assignPreassignedUpdates(transaction);
        }
    }

    private void processUnassignedWaitingTask(Update update, Transaction<?> transaction) throws DatasetException, SerializeException {
        int accessPointId;
        boolean canPreassignUpdate;
        LabelId labelId = update.getLabelId();
        if (update.getTaskType() == TaskType.REGISTER_LABEL) {
            String data = update.getData();
            Pin pin = RegisterLabelTask.parsePinFromData(data);
            Set<String> tags = RegisterLabelTask.parseTagsFromData(data);
            if (this.featureUnlock.isRegistrationWithLabelIdAllowed() || pin != null) {
                boolean result = this.labelInfoDataset.registerLabel(labelId, pin, tags, UserId.SYSTEM, transaction);
                if (result) {
                    this.updateStatusUpdater.finishRegisterLabel(update, transaction);
                } else {
                    this.updateStatusUpdater.failRegisterLabel(update, UpdateError.ERROR_CODE_UNLICENCED, transaction);
                }
            } else {
                this.updateStatusUpdater.failRegisterLabel(update, UpdateError.ERROR_CODE_PIN_MISSING, transaction);
            }
            return;
        }
        if (update.getTaskType() == TaskType.UNREGISTER_LABEL) {
            if (Config.isResetLabelsOnUnregister() && this.isSwitchToResetOrRegistrationPageWaiting(labelId)) {
                return;
            }
            this.labelInfoDataset.unregisterLabel(labelId, UserId.SYSTEM, transaction);
            this.updateStatusUpdater.finishRegisterLabel(update, transaction);
            return;
        }
        if (!this.labelInfoDataset.isRegistered(labelId) && !update.isLabelMaintenance()) {
            this.updateStatusUpdater.error(update, UpdateError.ERROR_CODE_UNREGISTERED, transaction);
            return;
        }
        if (update.getTaskType() == TaskType.UNLOCK_LABEL) {
            this.labelInfoDataset.removePin(labelId, transaction);
        }
        if ((canPreassignUpdate = this.accessPointCommunication.canPreassignUpdate(accessPointId = this.accessPointCommunication.getAssignedAccessPoint(labelId))) && !this.accessPointCommunication.isTaskSupported(accessPointId, update.getTaskType())) {
            this.updateStatusUpdater.error(update, UpdateError.ERROR_CODE_UNSUPPORTED_TASK, transaction);
            return;
        }
        if (accessPointId != 0 && canPreassignUpdate) {
            this.preassignUnassignedUpdate(update, accessPointId);
        } else {
            this.unassignableTasks.add(update);
        }
    }

    private void preassignUnassignedUpdate(Update update, int accessPointId) {
        PriorityQueue<PreassignedEntry> queue = this.preassignedTasksQueue.get(accessPointId);
        if (queue == null) {
            queue = new PriorityQueue();
            this.preassignedTasksQueue.put(accessPointId, queue);
        }
        LabelId labelId = update.getLabelId();
        WakeupStatistic wakeupStatistic = this.accessPointCommunication.getWakeupStatistic(labelId, accessPointId);
        PreassignedEntry entry = new PreassignedEntry(update, wakeupStatistic);
        queue.offer(entry);
    }

    private void assignPreassignedUpdates(Transaction<?> transaction) throws DatasetException, SerializeException {
        for (Map.Entry<Integer, PriorityQueue<PreassignedEntry>> entry : this.preassignedTasksQueue.entrySet()) {
            int accessPointId = entry.getKey();
            PriorityQueue<PreassignedEntry> queue = entry.getValue();
            boolean canAssignUpdate = true;
            while (!queue.isEmpty() && canAssignUpdate) {
                PreassignedEntry preassignedEntry = queue.poll();
                Update update = preassignedEntry.getUpdate();
                TaskPriority priority = update.getPriority();
                canAssignUpdate = this.accessPointCommunication.canAssignUpdate(accessPointId, priority);
                if (!this.labelInfoDataset.isRegistered(update.getLabelId()) && !update.isLabelMaintenance()) {
                    this.updateStatusUpdater.error(update, UpdateError.ERROR_CODE_UNREGISTERED, transaction);
                    continue;
                }
                if (!canAssignUpdate) continue;
                WakeupStatistic wakeupStatistic = preassignedEntry.getWakeupStatistic();
                this.scheduleUpdateTask(update, wakeupStatistic, transaction);
            }
        }
        this.preassignedTasksQueue.clear();
    }

    private void scheduleUpdateTask(Update update, WakeupStatistic wakeupStatistic, Transaction<?> transaction) throws DatasetException {
        if (Config.isSendUpdatesToLabelsWithPowerBad() || !wakeupStatistic.getPowerStatus().isBad()) {
            try {
                ExecutableTask task = this.updateStatusFactory.createTask(update);
                ExternalUpdateTask updateTask = this.updateTaskFactory.createUpdateTask(task, update.getTaskId());
                this.accessPointCommunication.scheduleUpdateTask(wakeupStatistic.getAccessPointId(), updateTask);
                this.updateStatusUpdater.assignToAccessPoint(update, wakeupStatistic, updateTask, transaction);
            }
            catch (UpdateCreationException exc) {
                logger.warn("Update task %s failed with error code %d: %s", new Object[]{update.getTaskId(), exc.getUpdateError().getCode(), exc.getMessage()});
                logger.logExceptionIfDebugEnabled((Throwable)exc);
                this.updateStatusUpdater.error(update, exc.getUpdateError(), transaction);
            }
            catch (SerializeException exc) {
                logger.warn("Failed to create task from update %s: %s", new Object[]{update.getTaskId(), exc.getMessage()});
                logger.logException((Throwable)exc);
                this.updateStatusUpdater.error(update, UpdateError.ERROR_CODE_INTERNAL, transaction);
            }
            catch (RuntimeException exc) {
                logger.warn("Update task %s failed with unknown error: %s", new Object[]{update.getTaskId(), exc.getMessage()});
                logger.logException((Throwable)exc);
                this.updateStatusUpdater.error(update, UpdateError.ERROR_CODE_UNKNOWN, transaction);
            }
        } else {
            this.updateStatusUpdater.error(update, UpdateError.ERROR_CODE_POWER_BAD, transaction);
        }
        logger.debug("Processed task %s", new Object[]{update.getTaskId()});
    }

    private void processUpdateTasksFromAccessPoints(Transaction<?> transaction) throws DatasetException {
        Map<Integer, List<ExternalUpdateTask>> unprocessedUpdateTasks = this.accessPointCommunication.getUnprocessedReceivedUpdateTasks();
        for (Map.Entry<Integer, List<ExternalUpdateTask>> entry : unprocessedUpdateTasks.entrySet()) {
            int accessPointId = entry.getKey();
            List<ExternalUpdateTask> updateTasks = entry.getValue();
            for (ExternalUpdateTask updateTask : updateTasks) {
                this.processUpdateTask(accessPointId, updateTask, transaction);
            }
        }
    }

    private void processUpdateTask(int accessPointId, ExternalUpdateTask updateTask, Transaction<?> transaction) throws DatasetException {
        UUID taskId = updateTask.getTaskId();
        if (updateTask.isFinished()) {
            Update update = this.waitingTaskCache.getAssignedWaitingTask(taskId);
            if (update != null) {
                logger.info("Processing update task %s in status %s", new Object[]{taskId, updateTask.getStatus()});
                this.updateStatusUpdater.finish(update, updateTask, transaction);
            } else {
                logger.debug("No assigned task for update task %s", new Object[]{taskId});
            }
        }
    }

    private void timeoutUnassignedTasks(Transaction<?> transaction) throws DatasetException {
        DateTime currentTime = DateTime.now();
        DateTime lastAssignmentTime = this.accessPointCommunication.getLastAssignmentTime();
        DateTime lastUpdateTimeout = lastAssignmentTime.plusMinutes(Config.getUnassignedTasksTimeoutInMinutes());
        for (Update update : this.unassignableTasks) {
            DateTime taskTimeout;
            if (update.getTaskType().isLabelMaintenance() || !currentTime.isAfter((ReadableInstant)(taskTimeout = update.getUpdatedAt().plusMinutes(Config.getUnassignedTasksTimeoutInMinutes()))) || !currentTime.isAfter((ReadableInstant)lastUpdateTimeout)) continue;
            logger.info("Set status of timedout task %s to TIMEOUT", new Object[]{update.getTaskId()});
            this.updateStatusUpdater.timeout(update, transaction);
        }
        this.unassignableTasks.clear();
    }

    private void timeoutAssignedTasks(Transaction<?> transaction) throws DatasetException {
        DateTime currentTime = DateTime.now();
        DateTime lastUpdateFinishedTime = this.updateStatusUpdater.getLastUpdateFinishedTime();
        DateTime lastUpdateTimeout = lastUpdateFinishedTime.plusMinutes(Config.getAssignedTasksTimeoutInMinutes());
        for (Update update : this.waitingTaskCache.getAssignedTasks()) {
            DateTime taskTimeout = update.getUpdatedAt().plusMinutes(Config.getAssignedTasksTimeoutInMinutes());
            if (!currentTime.isAfter((ReadableInstant)taskTimeout) || !currentTime.isAfter((ReadableInstant)lastUpdateTimeout)) continue;
            logger.info("Set status of lost update task %s to ERROR", new Object[]{update.getTaskId()});
            this.updateStatusUpdater.error(update, UpdateError.ERROR_CODE_UPDATE_LOST, update.getRetriesLeft(), transaction);
        }
    }

    private void showConnectionStatusAsUnknownDuringTransmission() throws DatasetException {
        int waitingTasks = this.waitingTaskCache.getAssignedWaitingTaskCount();
        if (waitingTasks > 0) {
            logger.info("%d assigned tasks - showing offline labels status as unknown on legacy labels", new Object[]{waitingTasks});
        }
        this.labelInfoDataset.showConnectionStatusAsUnknown(waitingTasks > 0);
    }

    private boolean isSwitchToResetOrRegistrationPageWaiting(LabelId labelId) {
        LabelType labelType = labelId.getLabelType();
        for (Update update : this.waitingTaskCache.getWaitingAndDelayedTasksForLabel(labelId)) {
            if (update.getTaskType() != TaskType.SWITCH_PAGE || update.getPage() != labelType.getResetPage() && update.getPage() != labelType.getRegistrationPage()) continue;
            return true;
        }
        return false;
    }

    public long getReloadTime() {
        return 1000L;
    }

    private static class PreassignedEntry
    implements Comparable<PreassignedEntry> {
        private final Update update;
        private final WakeupStatistic wakeupStatistic;

        public PreassignedEntry(Update update, WakeupStatistic wakeupStatistic) {
            this.update = update;
            this.wakeupStatistic = wakeupStatistic;
        }

        public Update getUpdate() {
            return this.update;
        }

        public WakeupStatistic getWakeupStatistic() {
            return this.wakeupStatistic;
        }

        private int getPriorityCode() {
            return this.update.getPriority().getPriorityCode();
        }

        @Override
        public int compareTo(PreassignedEntry other) {
            return other.getPriorityCode() - this.getPriorityCode();
        }
    }
}

