/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.server;

import at.mrdevelopment.esl.core.LabelId;
import at.mrdevelopment.esl.update.Update;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class WaitingTaskForLabelCache {
    private final Map<LabelId, Map<UUID, Update>> waitingTasksByLabel = new HashMap<LabelId, Map<UUID, Update>>();

    public void addWaitingTaskForLabel(LabelId labelId, Update update) {
        if (!this.waitingTasksByLabel.containsKey(labelId)) {
            this.waitingTasksByLabel.put(labelId, new HashMap());
        }
        this.waitingTasksByLabel.get(labelId).put(update.getTaskId(), update);
    }

    public boolean removeWatingTaskForLabel(LabelId labelId, UUID taskId) {
        if (this.waitingTasksByLabel.containsKey(labelId) && this.waitingTasksByLabel.get(labelId).containsKey(taskId)) {
            this.waitingTasksByLabel.get(labelId).remove(taskId);
            if (this.waitingTasksByLabel.get(labelId).isEmpty()) {
                this.waitingTasksByLabel.remove(labelId);
            }
            return true;
        }
        return false;
    }

    public Collection<Update> getTasks(LabelId labelId) {
        return this.waitingTasksByLabel.containsKey(labelId) ? this.waitingTasksByLabel.get(labelId).values() : Collections.emptySet();
    }

    public boolean hasWaitingTasks(LabelId labelId) {
        return this.waitingTasksByLabel.containsKey(labelId);
    }
}

