/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.server;

import at.mrdevelopment.esl.configuration.Config;
import at.mrdevelopment.esl.core.LabelDetailListener;
import at.mrdevelopment.esl.core.LabelDetailNotifier;
import at.mrdevelopment.esl.core.PowerStatus;
import at.mrdevelopment.esl.core.Status;
import at.mrdevelopment.esl.core.TransmissionStatistic;
import at.mrdevelopment.esl.core.UpdateStatusListener;
import at.mrdevelopment.esl.core.UpdateStatusNotifier;
import at.mrdevelopment.esl.core.UpdateTaskStatus;
import at.mrdevelopment.esl.persistence.DatasetException;
import at.mrdevelopment.esl.persistence.dataset.Transaction;
import at.mrdevelopment.esl.persistence.record.LabelDetail;
import at.mrdevelopment.esl.persistence.record.UpdateStatus;
import at.mrdevelopment.esl.type.LabelDetailType;
import at.mrdevelopment.esl.type.UpdateError;
import at.mrdevelopment.esl.type.WakeupStatistic;
import at.mrdevelopment.esl.update.Update;
import at.mrdevelopment.esl.updatetask.ExternalUpdateTask;
import at.mrdevelopment.esl.updatetask.GetConfigUpdateTask;
import at.mrdevelopment.esl.updatetask.LabelConfig;
import at.mrdevelopment.esl.updatetask.LabelCounter;
import at.mrdevelopment.esl.updatetask.LabelSensor;
import at.mrdevelopment.esl.updatetask.QueryCounterUpdateTask;
import at.mrdevelopment.esl.updatetask.QuerySensorUpdateTask;
import at.mrdevelopment.toolkit.log.ESLLogger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.joda.time.DateTime;

public class UpdateStatusUpdater
implements UpdateStatusNotifier,
LabelDetailNotifier {
    static ESLLogger logger = ESLLogger.getLogger(UpdateStatusUpdater.class);
    private final List<UpdateStatusListener> updateStatusListeners = new LinkedList<UpdateStatusListener>();
    private final List<LabelDetailListener> labelDetailListeners = new LinkedList<LabelDetailListener>();
    private DateTime lastUpdateFinishedTime = DateTime.now();

    public void addUpdateStatus(Update update, Transaction<?> transaction) throws DatasetException {
        this.notifyUpdateStatusAdded(update, transaction);
    }

    private void updateStatus(Update update, Status newStatus, UpdateError updateError, int newRetriesLeft, Transaction<?> transaction) throws DatasetException {
        if (update.hasUpdateStatus() && (update.getStatus() != newStatus || update.getRetriesLeft() != newRetriesLeft)) {
            UpdateStatus updateStatus = update.getUpdateStatus();
            updateStatus.setStatus(newStatus);
            updateStatus.setUpdateError(updateError);
            updateStatus.setRetriesLeft(Integer.valueOf(newRetriesLeft));
            this.notifyUpdateStatusChanged(update, transaction);
        }
    }

    public void replace(Update update, Transaction<?> transaction) throws DatasetException {
        this.updateStatus(update, Status.REPLACED, null, 0, transaction);
    }

    @Deprecated
    public void remove(Update update, Transaction<?> transaction) throws DatasetException {
        this.updateStatus(update, Status.REMOVED, null, 0, transaction);
    }

    public void cancel(Update update, Transaction<?> transaction) throws DatasetException {
        this.updateStatus(update, Status.CANCELED, null, 0, transaction);
    }

    public void start(Update update, Transaction<?> transaction) throws DatasetException {
        this.updateStatus(update, Status.WAITING, null, update.getRetriesLeft(), transaction);
    }

    public void timeout(Update update, Transaction<?> transaction) throws DatasetException {
        this.updateStatus(update, Status.TIMEOUT, null, 0, transaction);
    }

    public void error(Update update, UpdateError updateError, Transaction<?> transaction) throws DatasetException {
        this.updateStatus(update, Status.ERROR, updateError, 0, transaction);
    }

    public void error(Update update, UpdateError updateError, int retriesLeft, Transaction<?> transaction) throws DatasetException {
        this.updateStatus(update, Status.ERROR, updateError, retriesLeft, transaction);
    }

    public void assignToAccessPoint(Update update, WakeupStatistic wakeupStatistic, ExternalUpdateTask updateTask, Transaction<?> transaction) throws DatasetException {
        update.assignToAccessPoint(wakeupStatistic, updateTask, Config.isBatteryStatusClassificationEnabled() ? PowerStatus.UNKNOWN : wakeupStatistic.getPowerStatus());
        this.notifyUpdateStatusChanged(update, transaction);
    }

    public void skip(Update update, Transaction<?> transaction) throws DatasetException {
        update.setSuccessful();
        this.notifyUpdateStatusChanged(update, transaction);
    }

    public void finish(Update update, ExternalUpdateTask updateTask, Transaction<?> transaction) throws DatasetException {
        if (!updateTask.isFinished()) {
            logger.error("Called finished on %s with updateTask that is not in a finished state (status=%s)", new Object[]{update.getTaskId(), updateTask.getStatus()});
            return;
        }
        if (!update.hasUpdateStatus()) {
            logger.error("Update has no update status");
            return;
        }
        if (update.isFinished()) {
            logger.warn("Update is already in a final state (current status: %s, incoming status: %s)", new Object[]{update.getStatus(), updateTask.getStatus()});
            return;
        }
        UpdateTaskStatus updateTaskStatus = updateTask.getStatus();
        UpdateStatus updateStatus = update.getUpdateStatus();
        UpdateError updateError = updateTask.getUpdateError();
        if (updateError != null) {
            updateStatus.setUpdateError(updateTask.getUpdateError());
            if (updateError.isClearRetries()) {
                updateStatus.setRetriesLeft(Integer.valueOf(0));
            }
        }
        updateStatus.setStatus(updateTaskStatus.toStatus());
        TransmissionStatistic transmissionStatistic = updateTask.getTransmissionStatistic();
        updateStatus.setRssi(transmissionStatistic.getRssi());
        updateStatus.setLqi(transmissionStatistic.getLqi());
        updateStatus.setTransmissionTime(transmissionStatistic.getTransmissionTime());
        if (update.hasLabelDetails() && updateTask.isSuccessful()) {
            this.notifyNewLabelDetails(update, this.extractLabelDetails(update, updateTask), transaction);
        }
        this.notifyUpdateStatusChanged(update, transaction);
        this.lastUpdateFinishedTime = DateTime.now();
    }

    private Collection<LabelDetail> extractLabelDetails(Update update, ExternalUpdateTask updateTask) {
        ArrayList<LabelDetail> details;
        block4: {
            block5: {
                block3: {
                    details = new ArrayList<LabelDetail>();
                    if (!(updateTask instanceof QueryCounterUpdateTask)) break block3;
                    QueryCounterUpdateTask counterTask = (QueryCounterUpdateTask)updateTask;
                    for (LabelCounter labelCounter : counterTask.getCounters()) {
                        details.add(new LabelDetail(update.getLabelId(), LabelDetailType.QUERY_COUNTER, Integer.valueOf(labelCounter.getCounterId()), counterTask.getCounterValue(labelCounter), update.getTaskId()));
                    }
                    break block4;
                }
                if (!(updateTask instanceof QuerySensorUpdateTask)) break block5;
                QuerySensorUpdateTask sensorTask = (QuerySensorUpdateTask)updateTask;
                for (LabelSensor labelSensor : sensorTask.getSensors()) {
                    details.add(new LabelDetail(update.getLabelId(), LabelDetailType.QUERY_SENSOR, Integer.valueOf(labelSensor.getSensorId()), sensorTask.getSensorValue(labelSensor), update.getTaskId()));
                }
                break block4;
            }
            if (!(updateTask instanceof GetConfigUpdateTask)) break block4;
            GetConfigUpdateTask configTask = (GetConfigUpdateTask)updateTask;
            for (LabelConfig labelConfig : configTask.getConfigs()) {
                details.add(new LabelDetail(update.getLabelId(), LabelDetailType.GET_CONFIG, Integer.valueOf(labelConfig.getConfigId()), configTask.getConfigValue(labelConfig), update.getTaskId()));
            }
        }
        return details;
    }

    public void finishRegisterLabel(Update update, Transaction<?> transaction) throws DatasetException {
        this.updateStatus(update, Status.SUCCESSFUL, null, 0, transaction);
    }

    public void failRegisterLabel(Update update, UpdateError updateError, Transaction<?> transaction) throws DatasetException {
        this.updateStatus(update, Status.ERROR, updateError, 0, transaction);
    }

    public DateTime getLastUpdateFinishedTime() {
        return this.lastUpdateFinishedTime;
    }

    @Override
    public void registerUpdateStatusListener(UpdateStatusListener listener) {
        this.updateStatusListeners.add(listener);
    }

    @Override
    public void unregisterUpdateStatusListener(UpdateStatusListener listener) {
        this.updateStatusListeners.remove(listener);
    }

    private void notifyNewLabelDetails(Update update, Collection<LabelDetail> labelDetails, Transaction<?> transaction) {
        for (LabelDetailListener listener : this.labelDetailListeners) {
            listener.newLabelDetail(update, labelDetails, transaction);
        }
    }

    protected void notifyUpdateStatusAdded(Update update, Transaction<?> transaction) throws DatasetException {
        for (UpdateStatusListener listener : this.updateStatusListeners) {
            listener.updateStatusAdded(update, transaction);
        }
    }

    protected void notifyUpdateStatusChanged(Update update, Transaction<?> transaction) throws DatasetException {
        for (UpdateStatusListener listener : this.updateStatusListeners) {
            listener.updateStatusChanged(update, transaction);
        }
    }

    protected void notifyUpdateStatusRemoved(Update update, Transaction<?> transaction) {
        for (UpdateStatusListener listener : this.updateStatusListeners) {
            listener.updateStatusRemoved(update, transaction);
        }
    }

    @Override
    public void registerLabelDetailListener(LabelDetailListener listener) {
        this.labelDetailListeners.add(listener);
    }

    @Override
    public void unregisterLabelDetailListener(LabelDetailListener listener) {
        this.labelDetailListeners.remove(listener);
    }
}

