/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.server;

import at.mrdevelopment.esl.configuration.Config;
import at.mrdevelopment.esl.core.LabelId;
import at.mrdevelopment.esl.core.UpdateStatusListener;
import at.mrdevelopment.esl.custom.level1.Level1Interface;
import at.mrdevelopment.esl.persistence.DatasetException;
import at.mrdevelopment.esl.persistence.dataset.LabelInfoDataset;
import at.mrdevelopment.esl.persistence.dataset.Transaction;
import at.mrdevelopment.esl.persistence.dataset.UpdateStatusDataset;
import at.mrdevelopment.esl.persistence.record.UpdateStatus;
import at.mrdevelopment.esl.persistence.transaction.ORMTransaction;
import at.mrdevelopment.esl.persistence.transaction.ReadUncommittedTransactionSupplier;
import at.mrdevelopment.esl.tasks.TaskType;
import at.mrdevelopment.esl.type.UpdateInfo;
import at.mrdevelopment.esl.update.Update;
import at.mrdevelopment.toolkit.Shutdownable;
import at.mrdevelopment.toolkit.log.ComputationTimeLogger;
import at.mrdevelopment.toolkit.log.ESLLogger;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import org.hibernate.Query;

public class UpdateStatusCache
implements UpdateStatusListener,
Shutdownable {
    static ESLLogger logger = ESLLogger.getLogger(UpdateStatusCache.class);
    private static final String UPDATE_STATUS_QUERY = "select * from ESL_UPDATE_HISTORY, (select max(ESL_UPDATE_HISTORY.ID) as MAX_ID from ESL_UPDATE_HISTORY, ESL_TASK, ESL_REGISTERED_LABEL where ESL_UPDATE_HISTORY.ESL_TASK_ID = ESL_TASK.ID and ESL_REGISTERED_LABEL.LABEL_SERIAL = ESL_TASK.LABEL_SERIAL group by ESL_REGISTERED_LABEL.LABEL_SERIAL) SU where ESL_UPDATE_HISTORY.ID = SU.MAX_ID";
    private static final String IGNORE_QUERY_TASKS_UPDATE_STATUS_QUERY = String.format("select * from ESL_UPDATE_HISTORY, (select max(ESL_UPDATE_HISTORY.ID) as MAX_ID from ESL_UPDATE_HISTORY, ESL_TASK, ESL_REGISTERED_LABEL where ESL_UPDATE_HISTORY.ESL_TASK_ID = ESL_TASK.ID and ESL_REGISTERED_LABEL.LABEL_SERIAL = ESL_TASK.LABEL_SERIAL and ESL_TASK.TASK_TYPE not in %s group by ESL_REGISTERED_LABEL.LABEL_SERIAL) SU where ESL_UPDATE_HISTORY.ID = SU.MAX_ID", TaskType.QUERY_TASKS_SQL);
    private final SortedMap<LabelId, UpdateInfo> lastUpdates = new TreeMap<LabelId, UpdateInfo>();
    private final SortedMap<LabelId, UpdateInfo> lastUnsuccessfulUpdates = new TreeMap<LabelId, UpdateInfo>();
    private final LabelInfoDataset labelInfoDataset;
    private final Thread restoreThread;

    public UpdateStatusCache(Level1Interface level1, UpdateStatusDataset updateStatusDataset, LabelInfoDataset labelInfoDataset) throws DatasetException {
        this.labelInfoDataset = labelInfoDataset;
        this.restoreThread = new Thread(this.restoreFromDatabaseRunnable(level1, updateStatusDataset));
        this.restoreThread.start();
    }

    private Runnable restoreFromDatabaseRunnable(final Level1Interface level1, final UpdateStatusDataset dataset) {
        return new Runnable(){

            @Override
            public void run() {
                try {
                    ORMTransaction transaction = ReadUncommittedTransactionSupplier.fromTransactionSupplier(level1.getTransactionSupplier()).newTransaction();
                    try {
                        UpdateStatusCache.this.restoreFromDatabase(dataset, transaction);
                        transaction.commit();
                    }
                    catch (Exception exc) {
                        transaction.rollback();
                        throw new DatasetException((Throwable)exc);
                    }
                }
                catch (DatasetException exc) {
                    logger.warn("Error restoring latest update status: %s", new Object[]{exc.getMessage()});
                    logger.logException((Throwable)exc);
                }
            }
        };
    }

    private void restoreFromDatabase(UpdateStatusDataset dataset, Transaction<?> transaction) throws DatasetException {
        logger.info("Rebuilding last update status cache");
        ComputationTimeLogger timeLogger = new ComputationTimeLogger(logger).start();
        ORMTransaction<UpdateStatus> ormTransaction = ORMTransaction.fromTransaction(transaction);
        Query query = ormTransaction.createSQLQuery(Config.isIgnoreArchiveTasksForUpdateStatusQueries() ? IGNORE_QUERY_TASKS_UPDATE_STATUS_QUERY : UPDATE_STATUS_QUERY, UpdateStatus.class);
        timeLogger.logTimeInfo("Querying necessary updates");
        List<UpdateStatus> records = ormTransaction.query(query, UpdateStatus.class);
        logger.info("Query returns %d rows", new Object[]{records.size()});
        for (UpdateStatus update : records) {
            this.restoreUpdate(update);
        }
        logger.info("Finished rebuilding last update status cache");
        timeLogger.logTime("Time for rebuilding last update status cache");
    }

    private synchronized void restoreUpdate(UpdateStatus update) {
        if (!this.lastUpdates.containsKey(update.getTaskRecord().getLabelId())) {
            this.updateChanged(update);
        }
    }

    private void updateChanged(UpdateStatus updateStatus) {
        UpdateInfo updateInfo = UpdateInfo.fromUpdateStatus((UpdateStatus)updateStatus);
        LabelId labelId = updateStatus.getTaskRecord().getLabelId();
        if (this.labelInfoDataset.isRegistered(labelId)) {
            this.lastUpdates.put(labelId, updateInfo);
            if (updateStatus.getStatus().isUnsuccessful() && updateStatus.getRetriesLeft() == 0) {
                this.lastUnsuccessfulUpdates.put(labelId, updateInfo);
            } else {
                this.lastUnsuccessfulUpdates.remove(labelId);
            }
            this.labelInfoDataset.setLastUpdateInfo(labelId, updateInfo);
        }
    }

    public synchronized int getLabelCountWithLastUpdateStatus() {
        return this.lastUpdates.size();
    }

    public synchronized int getLabelCountWithLastUpdateStatusUnsuccessful() {
        return this.lastUnsuccessfulUpdates.size();
    }

    @Override
    public synchronized void updateStatusAdded(Update update, Transaction<?> transaction) {
        if (update.hasUpdateStatus()) {
            this.updateChanged(update.getUpdateStatus());
        }
    }

    @Override
    public synchronized void updateStatusChanged(Update update, Transaction<?> transaction) {
        if (update.hasUpdateStatus()) {
            this.updateChanged(update.getUpdateStatus());
        }
    }

    @Override
    public synchronized void updateStatusRemoved(Update update, Transaction<?> transaction) {
    }

    public void shutdown() {
        if (this.restoreThread != null && this.restoreThread.isAlive()) {
            this.restoreThread.interrupt();
        }
    }
}

