/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.server;

import at.mrdevelopment.esl.configuration.Config;
import at.mrdevelopment.esl.core.Page;
import at.mrdevelopment.esl.tasks.TaskType;
import at.mrdevelopment.esl.update.Update;
import at.mrdevelopment.toolkit.log.ESLLogger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class UpdateReplacementStrategy {
    static ESLLogger logger = ESLLogger.getLogger(UpdateReplacementStrategy.class);
    private final Map<ReplacementStrategyEntry, ActionType> actionMap = new HashMap<ReplacementStrategyEntry, ActionType>();

    public UpdateReplacementStrategy() {
        this.addEntry(UpdateType.IMAGE, UpdateType.IMAGE, PageType.SAME_PAGE, ActionType.REPLACE_OLD_UPDATE);
        this.addEntry(UpdateType.IMAGE, UpdateType.PRELOAD_IMAGE, PageType.SAME_PAGE, ActionType.DELAY_NEW_UPDATE);
        this.addEntry(UpdateType.IMAGE, UpdateType.SWITCH_PAGE, PageType.SAME_PAGE, ActionType.DELAY_NEW_UPDATE);
        this.addEntry(UpdateType.IMAGE, UpdateType.REFRESH_DISPLAY, PageType.NO_PAGE, ActionType.DELAY_NEW_UPDATE);
        this.addEntry(UpdateType.IMAGE, UpdateType.IMAGE, PageType.OTHER_PAGE, ActionType.DELAY_NEW_UPDATE);
        this.addEntry(UpdateType.IMAGE, UpdateType.PRELOAD_IMAGE, PageType.OTHER_PAGE, ActionType.NO_ACTION);
        this.addEntry(UpdateType.IMAGE, UpdateType.SWITCH_PAGE, PageType.OTHER_PAGE, ActionType.DELAY_NEW_UPDATE);
        this.addEntry(UpdateType.PRELOAD_IMAGE, UpdateType.IMAGE, PageType.SAME_PAGE, ActionType.REPLACE_OLD_UPDATE);
        this.addEntry(UpdateType.PRELOAD_IMAGE, UpdateType.PRELOAD_IMAGE, PageType.SAME_PAGE, ActionType.REPLACE_OLD_UPDATE);
        this.addEntry(UpdateType.PRELOAD_IMAGE, UpdateType.SWITCH_PAGE, PageType.SAME_PAGE, ActionType.DELAY_NEW_UPDATE);
        this.addEntry(UpdateType.PRELOAD_IMAGE, UpdateType.REFRESH_DISPLAY, PageType.NO_PAGE, ActionType.DELAY_NEW_UPDATE);
        this.addEntry(UpdateType.PRELOAD_IMAGE, UpdateType.IMAGE, PageType.OTHER_PAGE, ActionType.NO_ACTION);
        this.addEntry(UpdateType.PRELOAD_IMAGE, UpdateType.PRELOAD_IMAGE, PageType.OTHER_PAGE, ActionType.NO_ACTION);
        this.addEntry(UpdateType.PRELOAD_IMAGE, UpdateType.SWITCH_PAGE, PageType.OTHER_PAGE, ActionType.NO_ACTION);
        this.addEntry(UpdateType.SWITCH_PAGE, UpdateType.IMAGE, PageType.SAME_PAGE, ActionType.REPLACE_OLD_UPDATE);
        this.addEntry(UpdateType.SWITCH_PAGE, UpdateType.PRELOAD_IMAGE, PageType.SAME_PAGE, ActionType.DELAY_NEW_UPDATE);
        this.addEntry(UpdateType.SWITCH_PAGE, UpdateType.SWITCH_PAGE, PageType.SAME_PAGE, ActionType.REPLACE_OLD_UPDATE);
        this.addEntry(UpdateType.SWITCH_PAGE, UpdateType.REFRESH_DISPLAY, PageType.NO_PAGE, ActionType.DELAY_NEW_UPDATE);
        this.addEntry(UpdateType.SWITCH_PAGE, UpdateType.IMAGE, PageType.OTHER_PAGE, ActionType.REPLACE_OLD_UPDATE);
        this.addEntry(UpdateType.SWITCH_PAGE, UpdateType.PRELOAD_IMAGE, PageType.OTHER_PAGE, ActionType.NO_ACTION);
        this.addEntry(UpdateType.SWITCH_PAGE, UpdateType.SWITCH_PAGE, PageType.OTHER_PAGE, ActionType.REPLACE_OLD_UPDATE);
        this.addEntry(UpdateType.REFRESH_DISPLAY, UpdateType.IMAGE, PageType.NO_PAGE, ActionType.REPLACE_OLD_UPDATE);
        this.addEntry(UpdateType.REFRESH_DISPLAY, UpdateType.PRELOAD_IMAGE, PageType.NO_PAGE, ActionType.DELAY_NEW_UPDATE);
        this.addEntry(UpdateType.REFRESH_DISPLAY, UpdateType.SWITCH_PAGE, PageType.NO_PAGE, ActionType.REPLACE_OLD_UPDATE);
        this.addEntry(UpdateType.REFRESH_DISPLAY, UpdateType.REFRESH_DISPLAY, PageType.NO_PAGE, ActionType.DELAY_NEW_UPDATE);
        this.addEntry(UpdateType.RESET_COUNTER, UpdateType.RESET_COUNTER, PageType.NO_PAGE, ActionType.DELAY_NEW_UPDATE);
        this.addEntry(UpdateType.RESET_ALL_COUNTERS, UpdateType.RESET_ALL_COUNTERS, PageType.NO_PAGE, ActionType.DELAY_NEW_UPDATE);
        this.addEntry(UpdateType.SET_CONFIG, UpdateType.SET_CONFIG, PageType.NO_PAGE, ActionType.DELAY_NEW_UPDATE);
        this.addEntry(UpdateType.REBOOT, UpdateType.REBOOT, PageType.NO_PAGE, ActionType.REPLACE_OLD_UPDATE);
        this.addEntry(UpdateType.FORCE_CHANNEL_SCAN, UpdateType.FORCE_CHANNEL_SCAN, PageType.NO_PAGE, ActionType.NO_ACTION);
        this.addEntry(UpdateType.PROGRAM_KEYS, UpdateType.PROGRAM_KEYS, PageType.NO_PAGE, ActionType.DELAY_NEW_UPDATE);
        this.addEntry(UpdateType.FLASHING, UpdateType.FLASHING, PageType.NO_PAGE, ActionType.REPLACE_OLD_UPDATE);
        this.addEntry(UpdateType.IMAGE, UpdateType.UNREGISTER_LABEL, PageType.NO_PAGE, ActionType.DELAY_NEW_UPDATE);
        this.addEntry(UpdateType.PRELOAD_IMAGE, UpdateType.UNREGISTER_LABEL, PageType.NO_PAGE, ActionType.DELAY_NEW_UPDATE);
        this.addEntry(UpdateType.SWITCH_PAGE, UpdateType.UNREGISTER_LABEL, PageType.NO_PAGE, ActionType.DELAY_NEW_UPDATE);
        this.addEntry(UpdateType.REFRESH_DISPLAY, UpdateType.UNREGISTER_LABEL, PageType.NO_PAGE, ActionType.DELAY_NEW_UPDATE);
        this.addEntry(UpdateType.QUERY_COUNTER, UpdateType.UNREGISTER_LABEL, PageType.NO_PAGE, ActionType.DELAY_NEW_UPDATE);
        this.addEntry(UpdateType.QUERY_SENSOR, UpdateType.UNREGISTER_LABEL, PageType.NO_PAGE, ActionType.DELAY_NEW_UPDATE);
        this.addEntry(UpdateType.GET_CONFIG, UpdateType.UNREGISTER_LABEL, PageType.NO_PAGE, ActionType.DELAY_NEW_UPDATE);
        this.addEntry(UpdateType.SET_CONFIG, UpdateType.UNREGISTER_LABEL, PageType.NO_PAGE, ActionType.DELAY_NEW_UPDATE);
        this.addEntry(UpdateType.RESET_COUNTER, UpdateType.UNREGISTER_LABEL, PageType.NO_PAGE, ActionType.DELAY_NEW_UPDATE);
        this.addEntry(UpdateType.RESET_ALL_COUNTERS, UpdateType.UNREGISTER_LABEL, PageType.NO_PAGE, ActionType.DELAY_NEW_UPDATE);
        this.addEntry(UpdateType.REBOOT, UpdateType.UNREGISTER_LABEL, PageType.NO_PAGE, ActionType.DELAY_NEW_UPDATE);
        this.addEntry(UpdateType.FORCE_CHANNEL_SCAN, UpdateType.UNREGISTER_LABEL, PageType.NO_PAGE, ActionType.DELAY_NEW_UPDATE);
        this.addEntry(UpdateType.PROGRAM_KEYS, UpdateType.UNREGISTER_LABEL, PageType.NO_PAGE, ActionType.DELAY_NEW_UPDATE);
        this.addEntry(UpdateType.FLASHING, UpdateType.UNREGISTER_LABEL, PageType.NO_PAGE, ActionType.DELAY_NEW_UPDATE);
        this.addEntry(UpdateType.UNKNOWN, UpdateType.UNREGISTER_LABEL, PageType.NO_PAGE, ActionType.DELAY_NEW_UPDATE);
        this.addEntry(UpdateType.NDEF_MESSAGE, UpdateType.UNREGISTER_LABEL, PageType.NO_PAGE, ActionType.DELAY_NEW_UPDATE);
        this.addEntry(UpdateType.NDEF_MESSAGE, UpdateType.NDEF_MESSAGE, PageType.NO_PAGE, ActionType.REPLACE_OLD_UPDATE);
    }

    public Map<ActionType, Collection<Update>> getReplacementActions(Collection<Update> waitingUpdates, Update newUpdate, boolean forceReplaceOfWaitingTasks) {
        Map<ActionType, Collection<Update>> actionMap = this.createMap();
        for (Update waitingUpdate : waitingUpdates) {
            ActionType actionType = this.getReplacementAction(waitingUpdate, newUpdate, forceReplaceOfWaitingTasks);
            actionMap.get((Object)actionType).add(waitingUpdate);
        }
        return actionMap;
    }

    private ActionType getReplacementAction(Update waitingUpdate, Update newUpdate, boolean forceReplaceOfWaitingTasks) {
        if (!Config.isReplaceWaitingTasks()) {
            return ActionType.DELAY_NEW_UPDATE;
        }
        if (forceReplaceOfWaitingTasks) {
            return ActionType.REPLACE_OLD_UPDATE;
        }
        return this.getReplacementAction(waitingUpdate, newUpdate);
    }

    private ActionType getReplacementAction(Update waitingUpdate, Update newUpdate) {
        logger.info("Waiting update = %s", new Object[]{waitingUpdate.getTaskId()});
        logger.info("New update = %s", new Object[]{newUpdate.getTaskId()});
        logger.info("Waiting update task type = %s", new Object[]{waitingUpdate.getTaskType()});
        logger.info("New update task type = %s", new Object[]{newUpdate.getTaskType()});
        UpdateType waitingUpdateType = this.getUpdateType(waitingUpdate.getTaskType());
        UpdateType newUpdateType = this.getUpdateType(newUpdate.getTaskType());
        PageType pageType = this.getPageType(waitingUpdate.getPage(), newUpdate.getPage());
        ActionType actionType = this.getEntry(waitingUpdateType, newUpdateType, pageType);
        if (actionType == null) {
            actionType = ActionType.NO_ACTION;
        }
        logger.info("Replacement action: %s", new Object[]{actionType.toString()});
        return actionType;
    }

    private Map<ActionType, Collection<Update>> createMap() {
        HashMap<ActionType, Collection<Update>> updates = new HashMap<ActionType, Collection<Update>>();
        for (ActionType actionType : ActionType.values()) {
            updates.put(actionType, new ArrayList());
        }
        return updates;
    }

    private void addEntry(UpdateType waitingUpdateType, UpdateType newUpdateType, PageType pageType, ActionType actionType) {
        this.actionMap.put(new ReplacementStrategyEntry(waitingUpdateType, newUpdateType, pageType), actionType);
    }

    private ActionType getEntry(UpdateType waitingUpdateType, UpdateType newUpdateType, PageType pageType) {
        return this.actionMap.get(new ReplacementStrategyEntry(waitingUpdateType, newUpdateType, pageType));
    }

    private UpdateType getUpdateType(TaskType taskType) {
        if (taskType == TaskType.IMAGE) {
            return UpdateType.IMAGE;
        }
        if (taskType == TaskType.PRELOAD_IMAGE) {
            return UpdateType.PRELOAD_IMAGE;
        }
        if (taskType == TaskType.SWITCH_PAGE) {
            return UpdateType.SWITCH_PAGE;
        }
        if (taskType == TaskType.REFRESH_DISPLAY) {
            return UpdateType.REFRESH_DISPLAY;
        }
        if (taskType == TaskType.QUERY_COUNTER) {
            return UpdateType.QUERY_COUNTER;
        }
        if (taskType == TaskType.RESET_COUNTER) {
            return UpdateType.RESET_COUNTER;
        }
        if (taskType == TaskType.RESET_ALL_COUNTERS) {
            return UpdateType.RESET_ALL_COUNTERS;
        }
        if (taskType == TaskType.QUERY_SENSOR) {
            return UpdateType.QUERY_SENSOR;
        }
        if (taskType == TaskType.GET_CONFIG) {
            return UpdateType.GET_CONFIG;
        }
        if (taskType == TaskType.SET_CONFIG) {
            return UpdateType.SET_CONFIG;
        }
        if (taskType == TaskType.REBOOT) {
            return UpdateType.REBOOT;
        }
        if (taskType == TaskType.FORCE_CHANNEL_SCAN) {
            return UpdateType.FORCE_CHANNEL_SCAN;
        }
        if (taskType == TaskType.PROGRAM_KEYS) {
            return UpdateType.PROGRAM_KEYS;
        }
        if (taskType == TaskType.FLASHING) {
            return UpdateType.FLASHING;
        }
        if (taskType == TaskType.UNREGISTER_LABEL) {
            return UpdateType.UNREGISTER_LABEL;
        }
        if (taskType == TaskType.NDEF_MESSAGE) {
            return UpdateType.NDEF_MESSAGE;
        }
        return UpdateType.UNKNOWN;
    }

    private PageType getPageType(Page waitingUpdatePage, Page newUpdatePage) {
        if (waitingUpdatePage == null || newUpdatePage == null) {
            return PageType.NO_PAGE;
        }
        if (waitingUpdatePage.getPageIndex() == newUpdatePage.getPageIndex()) {
            return PageType.SAME_PAGE;
        }
        return PageType.OTHER_PAGE;
    }

    private static class ReplacementStrategyEntry {
        private final UpdateType waitingUpdateType;
        private final UpdateType newUpdateType;
        private final PageType pageType;

        public ReplacementStrategyEntry(UpdateType waitingUpdateType, UpdateType newUpdateType, PageType pageType) {
            this.waitingUpdateType = waitingUpdateType;
            this.newUpdateType = newUpdateType;
            this.pageType = pageType;
        }

        public int hashCode() {
            return ((31 + this.pageType.hashCode()) * 31 + this.newUpdateType.hashCode()) * 31 + this.waitingUpdateType.hashCode();
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            ReplacementStrategyEntry other = (ReplacementStrategyEntry)object;
            if (this.pageType != other.pageType) {
                return false;
            }
            if (this.newUpdateType != other.newUpdateType) {
                return false;
            }
            return this.waitingUpdateType == other.waitingUpdateType;
        }
    }

    public static enum ActionType {
        REPLACE_OLD_UPDATE,
        DELAY_NEW_UPDATE,
        REMOVE_NEW_UPDATE,
        NO_ACTION;

    }

    private static enum PageType {
        SAME_PAGE,
        OTHER_PAGE,
        NO_PAGE;

    }

    private static enum UpdateType {
        IMAGE,
        PRELOAD_IMAGE,
        SWITCH_PAGE,
        REFRESH_DISPLAY,
        QUERY_COUNTER,
        QUERY_SENSOR,
        GET_CONFIG,
        SET_CONFIG,
        RESET_COUNTER,
        RESET_ALL_COUNTERS,
        REBOOT,
        FORCE_CHANNEL_SCAN,
        PROGRAM_KEYS,
        FLASHING,
        UNREGISTER_LABEL,
        NDEF_MESSAGE,
        UNKNOWN;

    }
}

