/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.server;

import at.mrdevelopment.esl.configuration.Config;
import at.mrdevelopment.esl.core.LabelId;
import at.mrdevelopment.esl.core.Page;
import at.mrdevelopment.esl.persistence.DatasetException;
import at.mrdevelopment.esl.persistence.dataset.LabelActivePageDataset;
import at.mrdevelopment.esl.persistence.dataset.LabelPageContentDataset;
import at.mrdevelopment.esl.persistence.dataset.Transaction;
import at.mrdevelopment.esl.persistence.record.LabelActivePage;
import at.mrdevelopment.esl.persistence.record.LabelPageContent;
import at.mrdevelopment.esl.tasks.TaskType;
import at.mrdevelopment.esl.update.Update;
import at.mrdevelopment.toolkit.image.ImageSerializer;
import at.mrdevelopment.toolkit.log.ESLLogger;
import at.mrdevelopment.toolkit.xml.SerializeException;

public class UpdateImageSkippingStrategy {
    static ESLLogger logger = ESLLogger.getLogger(UpdateImageSkippingStrategy.class);
    private final LabelPageContentDataset labelPageContentDataset;
    private final LabelActivePageDataset labelActivePageDataset;

    public UpdateImageSkippingStrategy(LabelPageContentDataset labelPageContentDataset, LabelActivePageDataset labelActivePageDataset) {
        this.labelPageContentDataset = labelPageContentDataset;
        this.labelActivePageDataset = labelActivePageDataset;
    }

    public SkipAction getSkipAction(Update update, Transaction<?> transaction) {
        SkipAction skipAction = this.getSkipActionForUpdate(update, transaction);
        return this.getSkipActionForConfig(skipAction);
    }

    private SkipAction getSkipActionForConfig(SkipAction skipAction) {
        if (skipAction == SkipAction.SKIP && !Config.isAllowSkipTaskOnEqualImage() || skipAction == SkipAction.REPLACE_WITH_SWITCH_PAGE && !Config.isAllowToConvertImageTaskToSwitchPageTaskOnEqualImage()) {
            return SkipAction.SEND;
        }
        return skipAction;
    }

    private SkipAction getSkipActionForUpdate(Update update, Transaction<?> transaction) {
        try {
            if (update.hasImage() && (update.getTaskType() == TaskType.IMAGE || update.getTaskType() == TaskType.PRELOAD_IMAGE)) {
                LabelId labelId = update.getLabelId();
                LabelPageContent labelPageContent = this.labelPageContentDataset.queryByLabelAndPage(labelId, update.getPage(), transaction);
                Page activePage = this.getActivePage(update.getLabelId(), transaction);
                if (labelPageContent != null && update.getUpdateImage() != null && update.getUpdateImage().getImage() != null && labelPageContent.getUpdateImage() != null && labelPageContent.getUpdateImage().getImage() != null) {
                    byte[] oldImageHash;
                    byte[] newImageHash = update.getUpdateImage().getHash() != null ? update.getUpdateImage().getHash() : ImageSerializer.calculateHash((byte[])update.getUpdateImage().getImage());
                    byte[] byArray = oldImageHash = labelPageContent.getUpdateImage().getHash() != null ? labelPageContent.getUpdateImage().getHash() : ImageSerializer.calculateHash((byte[])labelPageContent.getUpdateImage().getImage());
                    if (ImageSerializer.compareHashes((byte[])newImageHash, (byte[])oldImageHash)) {
                        if (update.getTaskType() == TaskType.IMAGE && activePage != update.getPage()) {
                            return SkipAction.REPLACE_WITH_SWITCH_PAGE;
                        }
                        if (activePage == update.getPage() || update.getTaskType() == TaskType.PRELOAD_IMAGE) {
                            return SkipAction.SKIP;
                        }
                    }
                }
            }
        }
        catch (DatasetException exc) {
            logger.warn("Error during task skipping: %s", new Object[]{exc.getMessage()});
            logger.logExceptionIfDebugEnabled((Throwable)exc);
        }
        catch (SerializeException exc) {
            logger.warn("Error during task skipping: %s", new Object[]{exc.getMessage()});
            logger.logExceptionIfDebugEnabled((Throwable)exc);
        }
        return SkipAction.SEND;
    }

    private Page getActivePage(LabelId label, Transaction<?> transaction) throws DatasetException {
        LabelActivePage labelActivePage = this.labelActivePageDataset.queryByLabel(label, transaction);
        return labelActivePage != null ? labelActivePage.getActivePage() : Page.NO_PAGE;
    }

    public static enum SkipAction {
        SKIP,
        REPLACE_WITH_SWITCH_PAGE,
        SEND;

    }
}

