/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.server;

import at.mrdevelopment.esl.battery.BatteryClassificationCache;
import at.mrdevelopment.esl.configuration.ConfigurationChangedListener;
import at.mrdevelopment.esl.configuration.CustomConfigurationChangedListener;
import at.mrdevelopment.esl.custom.impl.Level1Implementation;
import at.mrdevelopment.esl.persistence.DatasetException;
import at.mrdevelopment.esl.persistence.dataset.BatteryReplacementRecordDataset;
import at.mrdevelopment.esl.persistence.dataset.ConfigurationDataset;
import at.mrdevelopment.esl.persistence.dataset.LabelActivePageDataset;
import at.mrdevelopment.esl.persistence.dataset.LabelDetailDataset;
import at.mrdevelopment.esl.persistence.dataset.LabelEventDataset;
import at.mrdevelopment.esl.persistence.dataset.LabelInfoDataset;
import at.mrdevelopment.esl.persistence.dataset.LabelInfoHistoryDataset;
import at.mrdevelopment.esl.persistence.dataset.LabelPageContentDataset;
import at.mrdevelopment.esl.persistence.dataset.Transaction;
import at.mrdevelopment.esl.persistence.dataset.UpdateStatusDataset;
import at.mrdevelopment.esl.persistence.maintenance.DatabaseMaintenanceStrategy;
import at.mrdevelopment.esl.persistence.maintenance.job.CronBasedJobConfiguration;
import at.mrdevelopment.esl.persistence.maintenance.job.ESLJob;
import at.mrdevelopment.esl.persistence.maintenance.job.ESLJobListener;
import at.mrdevelopment.esl.persistence.maintenance.job.JobConfiguration;
import at.mrdevelopment.esl.persistence.maintenance.job.JobLoggingAppender;
import at.mrdevelopment.esl.persistence.maintenance.job.JobStatistic;
import at.mrdevelopment.esl.persistence.maintenance.job.JobStatistics;
import at.mrdevelopment.esl.server.PersistLabelInfoCache;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.Shutdownable;
import at.mrdevelopment.toolkit.log.ESLLogger;
import at.mrdevelopment.toolkit.xml.SerializeException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Appender;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggingEvent;
import org.hibernate.SessionFactory;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobKey;
import org.quartz.JobListener;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerKey;
import org.quartz.UnableToInterruptJobException;
import org.quartz.impl.StdSchedulerFactory;

public class ServiceScheduler
implements Shutdownable,
ConfigurationChangedListener,
CustomConfigurationChangedListener {
    static ESLLogger logger = ESLLogger.getLogger(ServiceScheduler.class);
    private final Scheduler scheduler;
    private final Map<String, JobConfiguration> registeredJobs = new HashMap<String, JobConfiguration>();
    private final Map<String, Object> jobData = new HashMap<String, Object>();
    private final JobLoggingAppender loggingAppender;

    public ServiceScheduler(UpdateStatusDataset updateStatusDataset, ConfigurationDataset configurationDataset, LabelInfoHistoryDataset labelInfoHistoryDataset, LabelPageContentDataset labelPageContentDataset, LabelActivePageDataset labelActivePageDataset, BatteryReplacementRecordDataset batteryReplacementDataset, LabelDetailDataset labelDetailDataset, LabelEventDataset labelEventDataset, DatabaseMaintenanceStrategy cleanupStrategy, SessionFactory sessionFactory, Level1Implementation level1, PersistLabelInfoCache persistLabelInfoCache, LabelInfoDataset labelInfoDataset, BatteryClassificationCache batteryClassificationCache) throws InitializationException {
        this.jobData.put("updateStatusDataset", (Object)updateStatusDataset);
        this.jobData.put("labelInfoHistoryDataset", (Object)labelInfoHistoryDataset);
        this.jobData.put("labelActivePageDataset", (Object)labelActivePageDataset);
        this.jobData.put("labelPageContentDataset", (Object)labelPageContentDataset);
        this.jobData.put("level1", level1);
        this.jobData.put("batteryReplacementRecordDataset", (Object)batteryReplacementDataset);
        this.jobData.put("labelDetailDataset", (Object)labelDetailDataset);
        this.jobData.put("labelEventDataset", (Object)labelEventDataset);
        this.jobData.put("cleanupStrategy", cleanupStrategy);
        this.jobData.put("sessionFactory", sessionFactory);
        this.jobData.put("persistLabelInfoCache", persistLabelInfoCache);
        this.jobData.put("labelInfoDataset", labelInfoDataset);
        this.jobData.put("batteryClassificationCache", batteryClassificationCache);
        this.jobData.put("configurationDataset", (Object)configurationDataset);
        try {
            StdSchedulerFactory schedulerFactory = new StdSchedulerFactory(this.initProperties());
            this.scheduler = schedulerFactory.getScheduler();
            this.scheduler.getListenerManager().addJobListener((JobListener)new ESLJobListener(this));
            this.loggingAppender = new JobLoggingAppender();
            this.loggingAppender.setName(((Object)((Object)this.loggingAppender)).getClass().getSimpleName());
            Logger.getLogger(ESLJobListener.class).addAppender((Appender)this.loggingAppender);
            Logger.getLogger(ESLJob.class).addAppender((Appender)this.loggingAppender);
            this.scheduler.start();
        }
        catch (SchedulerException exc) {
            throw new InitializationException((Throwable)exc);
        }
    }

    private Properties initProperties() {
        Properties properties = new Properties();
        properties.put("org.quartz.scheduler.instanceName", "ServiceScheduler");
        properties.put("org.quartz.threadPool.threadCount", "1");
        properties.put("org.quartz.jobStore.class", "org.quartz.simpl.RAMJobStore");
        properties.put("org.quartz.scheduler.skipUpdateCheck", "true");
        return properties;
    }

    public void registerJob(JobConfiguration jobConfiguration, Transaction<?> transaction) {
        this.registerJob(jobConfiguration, new HashMap<String, Object>(), transaction);
    }

    public void registerJob(JobConfiguration jobConfiguration, Map<String, Object> additionalJobData, Transaction<?> transaction) {
        try {
            this.scheduleJob(jobConfiguration, additionalJobData, transaction);
            Logger.getLogger(jobConfiguration.getJobClass()).addAppender((Appender)this.loggingAppender);
            this.registeredJobs.put(jobConfiguration.getJobIdentifier(), jobConfiguration);
        }
        catch (Exception exc) {
            logger.warn("Could not initialize schedule for %s: %s", new Object[]{jobConfiguration.getJobClass().getSimpleName(), exc.getMessage()});
            logger.logExceptionIfDebugEnabled((Throwable)exc);
        }
    }

    public void unregisterJob(String jobIdentifier) {
        this.registeredJobs.remove(jobIdentifier);
        this.deleteJob(jobIdentifier);
    }

    @Override
    public void configurationChanged(String key, String value, Transaction<?> transaction) throws Exception {
        String jobIdentifier = this.findJobByScheduleKey(key);
        if (jobIdentifier != null) {
            try {
                this.updateJob(value, jobIdentifier, transaction);
            }
            catch (Exception exc) {
                logger.warn("Could not update schedule for %s: %s", new Object[]{jobIdentifier, exc.getMessage()});
                logger.logExceptionIfDebugEnabled((Throwable)exc);
            }
        }
        this.updateJobEnabledState(key, value);
    }

    private void updateJobEnabledState(String configKey, String value) {
        for (JobConfiguration jobConfiguration : this.registeredJobs.values()) {
            CronBasedJobConfiguration cronBasedJobConfiguration;
            if (!(jobConfiguration instanceof CronBasedJobConfiguration) || !(cronBasedJobConfiguration = (CronBasedJobConfiguration)jobConfiguration).getConfigKeyEnabled().equals(configKey)) continue;
            cronBasedJobConfiguration.updateEnabledState(value);
        }
    }

    @Override
    public void customConfigurationChanged(String key, String value, Transaction<?> transaction) throws Exception {
        this.configurationChanged(key, value, transaction);
    }

    private String findJobByScheduleKey(String configKey) {
        for (Map.Entry<String, JobConfiguration> entry : this.registeredJobs.entrySet()) {
            CronBasedJobConfiguration cronBasedJobConfiguration;
            if (!(entry.getValue() instanceof CronBasedJobConfiguration) || !(cronBasedJobConfiguration = (CronBasedJobConfiguration)entry.getValue()).getConfigKeySchedule().equals(configKey)) continue;
            return entry.getKey();
        }
        return null;
    }

    public JobStatistics getJobStatistics() throws InitializationException {
        Map<String, JobConfiguration> jobs = Collections.unmodifiableMap(new HashMap<String, JobConfiguration>(this.registeredJobs));
        return new JobStatistics(this, this.scheduler, jobs);
    }

    public void triggerJob(String jobClassName) throws SchedulerException {
        JobConfiguration jobConfiguration = this.getJobConfiguration(jobClassName);
        JobKey jobKey = jobConfiguration.getJobKey();
        JobDetail jobDetail = this.scheduler.getJobDetail(jobKey);
        JobDataMap jobDataMap = jobDetail.getJobDataMap();
        jobDataMap.put("manualTrigger", true);
        this.scheduler.triggerJob(jobKey, jobDataMap);
    }

    private void deleteJob(String jobIdentifier) {
        try {
            this.scheduler.deleteJob(new JobKey(jobIdentifier));
        }
        catch (SchedulerException exc) {
            logger.warn("Could not delete job %s: %s", new Object[]{jobIdentifier, exc.getMessage()});
            logger.logExceptionIfDebugEnabled((Throwable)exc);
        }
    }

    public boolean cancelJobExecution(String jobClassName) throws UnableToInterruptJobException {
        JobConfiguration jobConfiguration = this.getJobConfiguration(jobClassName);
        return this.scheduler.interrupt(jobConfiguration.getJobKey());
    }

    private void scheduleJob(JobConfiguration jobConfiguration, Map<String, Object> additionalJobData, Transaction<?> transaction) throws Exception {
        HashMap<String, String> additionalCronJobData = new HashMap<String, String>();
        if (jobConfiguration instanceof CronBasedJobConfiguration) {
            CronBasedJobConfiguration cronBasedJobConfiguration = (CronBasedJobConfiguration)jobConfiguration;
            cronBasedJobConfiguration.updateEnabledState(cronBasedJobConfiguration.getEnabledConfiguration().getValue());
            additionalCronJobData.put("enabled", cronBasedJobConfiguration.getConfigKeyEnabled());
        }
        JobDetail job = JobBuilder.newJob(jobConfiguration.getJobClass()).withIdentity(jobConfiguration.getJobIdentifier()).build();
        job.getJobDataMap().putAll(this.jobData);
        job.getJobDataMap().put(String.format("%sExecutionCount", jobConfiguration.getJobClass().getSimpleName()), 0);
        job.getJobDataMap().put(String.format("%sExecutionTime", jobConfiguration.getJobClass().getSimpleName()), 0L);
        job.getJobDataMap().put("manualTrigger", false);
        job.getJobDataMap().put("previousExecution", null);
        job.getJobDataMap().putAll(additionalJobData);
        job.getJobDataMap().putAll(additionalCronJobData);
        Trigger trigger = jobConfiguration.createTrigger();
        this.scheduler.scheduleJob(job, trigger);
    }

    private void updateJob(String newConfigValue, String jobIdentifier, Transaction<?> transaction) throws DatasetException, SchedulerException {
        JobConfiguration jobConfiguration = this.registeredJobs.get(jobIdentifier);
        this.scheduler.rescheduleJob(new TriggerKey(jobConfiguration.getTriggerName()), (Trigger)jobConfiguration.createTriggerWithSchedule(newConfigValue));
    }

    public void shutdown() {
        try {
            this.scheduler.shutdown();
        }
        catch (SchedulerException exc) {
            logger.warn("Could not shutdown maintenance scheduler: %s", new Object[]{exc.getMessage()});
            logger.logExceptionIfDebugEnabled((Throwable)exc);
        }
    }

    public boolean isJobEnabled(String jobIdentifier, Transaction<?> transaction) throws DatasetException, SerializeException {
        return this.registeredJobs.get(jobIdentifier).isEnabled();
    }

    public JobConfiguration getJobConfiguration(String jobClassName) {
        for (String jobIdentifier : this.registeredJobs.keySet()) {
            if (!jobIdentifier.equals(jobClassName)) continue;
            return this.registeredJobs.get(jobIdentifier);
        }
        return null;
    }

    public JobStatistic getJobStatistic(String jobName, JobExecutionContext context) throws InitializationException {
        JobConfiguration jobConfiguration = this.getJobConfiguration(jobName);
        if (jobConfiguration != null) {
            return new JobStatistic(jobConfiguration.isEnabled(), jobName, context.getJobDetail(), context.getTrigger(), context);
        }
        return null;
    }

    public JobStatistic getJobStatistic(String jobName) throws InitializationException {
        JobStatistics jobStatistics = this.getJobStatistics();
        for (JobStatistic statistic : jobStatistics.getStatistics()) {
            if (!statistic.getName().equals(jobName)) continue;
            return statistic;
        }
        return null;
    }

    public List<LoggingEvent> getLoggingEvents() {
        return this.loggingAppender.getLoggingEvents();
    }
}

