/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.server;

import at.mrdevelopment.esl.core.ESLSystemDefaults;
import at.mrdevelopment.esl.persistence.maintenance.CompressType;
import at.mrdevelopment.esl.persistence.maintenance.DatabaseMaintenanceOptions;
import at.mrdevelopment.esl.server.ServerFactory;
import at.mrdevelopment.toolkit.Version;
import at.mrdevelopment.toolkit.info.Info;
import at.mrdevelopment.toolkit.log.ESLLogger;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;

public class ServerOptionParser {
    static ESLLogger logger = ESLLogger.getLogger(ServerOptionParser.class);
    private static final File DEFAULT_DATABASE_CONFIG_FILE = new File("config/database.xml");
    private final int serviceLevel;
    private final int listenPort;
    private final boolean ssl;
    private final File databaseConfigFile;
    private final boolean createDb;
    private final boolean cleanupDb;
    private final CompressType compressDbType;
    private final boolean purgeDb;
    private final boolean migrateDb;
    private final File migrationDatabaseConfiguration;
    private final Collection<String> networkInterfaces;
    private final File exportFile;
    private final File importFile;
    private final String bindAddress;

    public ServerOptionParser(String[] args, Info info, String applicationName) throws IOException {
        this(args, info, applicationName, ServerFactory.getDefaultServiceLevel());
    }

    public ServerOptionParser(String[] args, Info info, String applicationName, int defaultServiceLevel) throws IOException {
        ESLSystemDefaults defaults = new ESLSystemDefaults();
        OptionParser parser = new OptionParser();
        ArgumentAcceptingOptionSpec optionPort = parser.accepts("port", "HTTP(S) port").withRequiredArg().ofType(Integer.class).defaultsTo((Object)defaults.getServicePort(), (Object[])new Integer[0]);
        ArgumentAcceptingOptionSpec optionSsl = parser.accepts("ssl", "Use SSL for server webservice").withRequiredArg().ofType(Boolean.class).defaultsTo((Object)defaults.isUseServerSSL(), (Object[])new Boolean[0]);
        ArgumentAcceptingOptionSpec optionDatabaseConfig = parser.accepts("db-config", "Database configuration file").withRequiredArg().ofType(File.class).defaultsTo((Object)DEFAULT_DATABASE_CONFIG_FILE, (Object[])new File[0]);
        ArgumentAcceptingOptionSpec optionServiceLevel = parser.accepts("level", "Start ESL server with this integration level").withRequiredArg().ofType(Integer.class).defaultsTo((Object)defaultServiceLevel, (Object[])new Integer[0]);
        OptionSpecBuilder optionCreateDb = parser.accepts("create-db", "Create database tables and exit");
        OptionSpecBuilder optionCleanupDb = parser.accepts("cleanup-db", "Cleans up database tables and exit");
        ArgumentAcceptingOptionSpec optionCompressDb = parser.accepts("compress-db", "Cleans up database tables and exit").withOptionalArg().ofType(String.class).defaultsTo((Object)CompressType.INPLACE_COMPRESS.getArgument(), (Object[])new String[0]);
        OptionSpecBuilder optionPurgeDb = parser.accepts("purge-db", "Purges database tables and exit");
        OptionSpecBuilder optionMigrateDb = parser.accepts("migrate-db", "Migrates data from another database and exit");
        ArgumentAcceptingOptionSpec optionMigrationDatabaseConfig = parser.accepts("migrate-db-config", "The Database configuration file of the database to migrate from").withOptionalArg().ofType(File.class);
        ArgumentAcceptingOptionSpec optionInterfaces = parser.accepts("disabled-interfaces", "The network interfaces to disable the API web server for").withRequiredArg().ofType(String.class).defaultsTo((Object)"", (Object[])new String[0]);
        OptionSpecBuilder optionHelp = parser.accepts("help", "Show this help");
        ArgumentAcceptingOptionSpec optionExportFile = parser.accepts("export", "Exports all configuration data to the given file and exit").withRequiredArg().ofType(File.class);
        ArgumentAcceptingOptionSpec optionImportFile = parser.accepts("import", "Imports all configuration data from the given file").withRequiredArg().ofType(File.class);
        ArgumentAcceptingOptionSpec optionBindAddress = parser.accepts("bind-address", "The network address to bind the webserver(s) to").withRequiredArg().ofType(String.class).defaultsTo((Object)"", (Object[])new String[0]);
        OptionSpecBuilder optionVersion = parser.accepts("version", "Show version and exit");
        OptionSet options = parser.parse(args);
        if (options.has((OptionSpec)optionHelp)) {
            parser.printHelpOn((OutputStream)System.out);
            System.exit(0);
        }
        if (options.has((OptionSpec)optionVersion)) {
            Version version = info.getVersion();
            logger.info("%s %s, Build %d", new Object[]{applicationName, version, version.getBuild()});
            System.exit(0);
        }
        this.databaseConfigFile = (File)options.valueOf((OptionSpec)optionDatabaseConfig);
        this.serviceLevel = (Integer)options.valueOf((OptionSpec)optionServiceLevel);
        this.listenPort = (Integer)options.valueOf((OptionSpec)optionPort);
        this.ssl = (Boolean)options.valueOf((OptionSpec)optionSsl);
        this.createDb = options.has((OptionSpec)optionCreateDb);
        this.cleanupDb = options.has((OptionSpec)optionCleanupDb);
        this.compressDbType = options.has((OptionSpec)optionCompressDb) ? CompressType.getCompressTypeFromString((String)((String)options.valueOf((OptionSpec)optionCompressDb))) : null;
        this.purgeDb = options.has((OptionSpec)optionPurgeDb);
        this.migrateDb = options.has((OptionSpec)optionMigrateDb);
        this.migrationDatabaseConfiguration = options.has((OptionSpec)optionMigrationDatabaseConfig) ? (File)options.valueOf((OptionSpec)optionMigrationDatabaseConfig) : null;
        this.networkInterfaces = options.has((OptionSpec)optionInterfaces) ? this.parseNetworkInterfaces((String)options.valueOf((OptionSpec)optionInterfaces)) : null;
        this.exportFile = options.has((OptionSpec)optionExportFile) ? (File)options.valueOf((OptionSpec)optionExportFile) : null;
        this.importFile = options.has((OptionSpec)optionImportFile) ? (File)options.valueOf((OptionSpec)optionImportFile) : null;
        this.bindAddress = options.has((OptionSpec)optionBindAddress) ? (String)options.valueOf((OptionSpec)optionBindAddress) : null;
    }

    private Collection<String> parseNetworkInterfaces(String interfacesString) {
        return Lists.newArrayList((Iterable)Splitter.on((String)";").split((CharSequence)interfacesString));
    }

    public int getServiceLevel() {
        return this.serviceLevel;
    }

    public int getListenPort() {
        return this.listenPort;
    }

    public boolean isSsl() {
        return this.ssl;
    }

    public File getDatabaseConfigFile() {
        return this.databaseConfigFile;
    }

    public DatabaseMaintenanceOptions createDatabaseMaintenanceOptions() {
        return new DatabaseMaintenanceOptions(this.createDb, this.cleanupDb, this.compressDbType, this.purgeDb, this.migrateDb, this.migrationDatabaseConfiguration);
    }

    public Collection<String> getNetworkInterfaces() {
        return this.networkInterfaces;
    }

    public File getExportFile() {
        return this.exportFile;
    }

    public File getImportFile() {
        return this.importFile;
    }

    public String getBindAddress() {
        return this.bindAddress;
    }
}

