/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.server;

import at.mrdevelopment.esl.admin.platform.EnvironmentProperties;
import at.mrdevelopment.esl.core.ESLProcessingTask;
import at.mrdevelopment.esl.core.ESLService;
import at.mrdevelopment.esl.msp.MSPConfiguration;
import at.mrdevelopment.esl.msp.MSPStatusXMLUploader;
import at.mrdevelopment.esl.server.MSPConfigurationBuilder;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.authentication.UserId;
import at.mrdevelopment.toolkit.log.ESLLogger;
import org.joda.time.DateTime;
import org.joda.time.Minutes;
import org.joda.time.ReadableInstant;

public class ServerMSPStatusTask
implements ESLProcessingTask {
    static ESLLogger logger = ESLLogger.getLogger(ESLProcessingTask.class);
    private MSPStatusXMLUploader uploader;
    private ESLService eslService;
    private DateTime lastUploadTime = DateTime.now();

    public ServerMSPStatusTask(ESLService eslService) throws InitializationException {
        this.eslService = eslService;
        this.uploader = new MSPStatusXMLUploader();
    }

    public void run() throws Exception {
        MSPConfiguration mspConfiguration = MSPConfigurationBuilder.createMSPConfigurationForServer(new EnvironmentProperties(true));
        if (mspConfiguration.isEnabled() && Minutes.minutesBetween((ReadableInstant)this.lastUploadTime, (ReadableInstant)DateTime.now()).getMinutes() >= mspConfiguration.getUploadInterval()) {
            this.uploader.uploadToMSP(mspConfiguration, this.eslService.getServiceStatus(UserId.SYSTEM));
            this.lastUploadTime = DateTime.now();
        }
    }
}

