/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.server;

import at.mrdevelopment.esl.admin.platform.config.storage.PlatformStorage;
import at.mrdevelopment.esl.custom.ServerStartupSettings;
import at.mrdevelopment.esl.server.Level1Server;
import at.mrdevelopment.esl.server.PluginLoader;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.log.ESLLogger;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

public class ServerFactory {
    static ESLLogger logger = ESLLogger.getLogger(ServerFactory.class);
    private final ServerStartupSettings serverStartupSettings;

    public ServerFactory(ServerStartupSettings serverStartupSettings) {
        this.serverStartupSettings = serverStartupSettings;
    }

    public Level1Server loadServer(File databaseConfigFile, boolean useSSL) throws Throwable {
        return this.loadServer(databaseConfigFile, new PluginLoader(new String[]{"drivers"}, new String[]{"plugins"}, "ESL_PLUGIN_PATH", "../custom", "../custom-webservice"), null, useSSL);
    }

    public Level1Server loadServer(File databaseConfigFile, PluginLoader pluginLoader, PlatformStorage platformStorage, boolean useSSL) throws Throwable {
        try {
            for (File file : pluginLoader.getConnectorConfigurationFiles()) {
                this.serverStartupSettings.getConnectorConfiguration().addConnectorConfiguration(file);
            }
            for (File file : pluginLoader.getRecordsConfigurationFiles()) {
                this.serverStartupSettings.getConnectorConfiguration().addRecordConfiguration(file);
            }
            for (File file : pluginLoader.getDatasetsConfigurationFiles()) {
                this.serverStartupSettings.getConnectorConfiguration().addDatasetConfiguration(file);
            }
            if (pluginLoader.hasRenderingEnginePlugin()) {
                this.serverStartupSettings.getConnectorConfiguration().addRenderingConfiguration(pluginLoader.getRenderingEngineFile());
            }
            ClassLoader classLoader = pluginLoader.getClassLoader();
            String serverClassName = ServerFactory.getServerClassNameForServiceLevel(this.serverStartupSettings.getServiceLevel());
            Class<?> serverClass = classLoader.loadClass(serverClassName);
            Constructor<?> constructor = serverClass.getConstructor(File.class, ServerStartupSettings.class, ClassLoader.class, PlatformStorage.class, Boolean.TYPE);
            return (Level1Server)constructor.newInstance(databaseConfigFile, this.serverStartupSettings, classLoader, platformStorage, useSSL);
        }
        catch (InvocationTargetException exc) {
            throw exc.getCause();
        }
        catch (InstantiationException exc) {
            throw exc.getCause();
        }
        catch (ClassNotFoundException exc) {
            throw new InitializationException((Throwable)exc);
        }
        catch (SecurityException exc) {
            throw new InitializationException((Throwable)exc);
        }
        catch (NoSuchMethodException exc) {
            throw new InitializationException((Throwable)exc);
        }
        catch (IllegalArgumentException exc) {
            throw new InitializationException((Throwable)exc);
        }
        catch (IllegalAccessException exc) {
            throw new InitializationException((Throwable)exc);
        }
    }

    public static String getServerClassNameForServiceLevel(int serviceLevel) {
        return String.format("at.mrdevelopment.esl.server.Level%dServer", serviceLevel);
    }

    public static int getDefaultServiceLevel() {
        for (int serviceLevel = 3; serviceLevel >= 1; --serviceLevel) {
            try {
                String serverClassName = ServerFactory.getServerClassNameForServiceLevel(serviceLevel);
                Class.forName(serverClassName);
                return serviceLevel;
            }
            catch (ClassNotFoundException ignore) {
                logger.debug("Class for server level %d not found", new Object[]{serviceLevel});
                continue;
            }
        }
        return 1;
    }
}

