/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.server;

import at.mrdevelopment.esl.core.DefaultPeriodicTasksExecutor;
import at.mrdevelopment.esl.core.ESLProcessing;
import at.mrdevelopment.esl.core.ESLProcessingTask;
import at.mrdevelopment.esl.persistence.dataset.Transaction;
import at.mrdevelopment.esl.persistence.dataset.TransactionSupplier;
import at.mrdevelopment.esl.persistence.transaction.AutoCommitTransactionSupplier;
import at.mrdevelopment.esl.persistence.transaction.ORMTransaction;
import at.mrdevelopment.esl.persistence.transaction.TaskUpdateTransactionSupplier;
import at.mrdevelopment.esl.server.ScheduledTasksBlockingQueue;
import at.mrdevelopment.esl.server.WaitingTaskCache;
import at.mrdevelopment.esl.tasks.Task;
import at.mrdevelopment.esl.type.TaskQueueEntry;
import at.mrdevelopment.esl.type.TaskTransaction;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.log.ESLLogger;
import java.util.Collection;

public class ScheduledTaskProcessing
extends DefaultPeriodicTasksExecutor {
    protected static final int MAX_UPDATE_BATCH_SIZE = 1000;
    static ESLLogger logger = ESLLogger.getLogger(ScheduledTaskProcessing.class);
    private final ESLProcessing eslProcessing;
    private final TransactionSupplier transactionSupplier;
    private final ScheduledTasksBlockingQueue scheduledTasks;
    private final WaitingTaskCache waitingTaskCache;

    public ScheduledTaskProcessing(ESLProcessing eslProcessing, WaitingTaskCache waitingTaskCache, TransactionSupplier transactionSupplier) throws InitializationException {
        this.eslProcessing = eslProcessing;
        this.waitingTaskCache = waitingTaskCache;
        this.transactionSupplier = AutoCommitTransactionSupplier.fromTransactionSupplier(transactionSupplier);
        this.scheduledTasks = new ScheduledTasksBlockingQueue();
        this.createProcessingTasks();
    }

    private void createProcessingTasks() throws InitializationException {
        this.addProcessingTask(new ESLProcessingTask(){

            public void run() throws Exception {
                try {
                    Collection<TaskQueueEntry> entries = ScheduledTaskProcessing.this.scheduledTasks.take();
                    ORMTransaction ormTransaction = TaskUpdateTransactionSupplier.fromTransactionSupplier(ScheduledTaskProcessing.this.transactionSupplier, 1000, ScheduledTaskProcessing.this.waitingTaskCache).newTransaction();
                    try {
                        for (TaskQueueEntry entry : entries) {
                            ScheduledTaskProcessing.this.eslProcessing.processTask(entry.getTransaction(), entry.getTask(), (Transaction)ormTransaction);
                        }
                        if (!ormTransaction.isCommitted()) {
                            ormTransaction.commit();
                        }
                    }
                    catch (Exception exc) {
                        ormTransaction.rollback();
                        throw exc;
                    }
                }
                catch (InterruptedException ignore) {
                    logger.info("Stopping scheduled task processing");
                }
            }
        });
    }

    public void scheduleTask(TaskTransaction transaction, Task task) {
        this.scheduledTasks.offer(new TaskQueueEntry(transaction, task));
    }

    public long getReloadTime() {
        return 0L;
    }

    public int getScheduledTaskCount() {
        return this.scheduledTasks.size();
    }
}

