/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.server;

import at.mrdevelopment.esl.core.ESLProcessing;
import at.mrdevelopment.esl.persistence.dataset.Transaction;
import at.mrdevelopment.esl.persistence.dataset.TransactionSupplier;
import at.mrdevelopment.esl.persistence.transaction.BatchUpdateTransactionSupplier;
import at.mrdevelopment.esl.persistence.transaction.ORMTransaction;
import at.mrdevelopment.esl.tasks.AbortRequest;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.log.ESLLogger;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;

public class ScheduledAbortRequestProcessing {
    static ESLLogger logger = ESLLogger.getLogger(ScheduledAbortRequestProcessing.class);
    private static final int MAX_UPDATE_BATCH_SIZE = 100;
    private final BlockingQueue<AbortRequest> scheduledAbortRequests;
    private final ESLProcessing eslProcessing;
    private final TransactionSupplier transactionSupplier;

    public ScheduledAbortRequestProcessing(ESLProcessing eslProcessing, TransactionSupplier transactionSupplier) throws InitializationException {
        this.eslProcessing = eslProcessing;
        this.transactionSupplier = transactionSupplier;
        this.scheduledAbortRequests = new LinkedBlockingQueue<AbortRequest>();
    }

    public void processAbortRequests() throws Exception {
        AbortRequest abortRequest;
        if (this.scheduledAbortRequests.size() > 0 && (abortRequest = (AbortRequest)this.scheduledAbortRequests.poll()) != null) {
            ArrayList abortRequests = Lists.newArrayList();
            abortRequests.add(abortRequest);
            this.scheduledAbortRequests.drainTo(abortRequests);
            ORMTransaction transaction = BatchUpdateTransactionSupplier.fromTransactionSupplier(this.transactionSupplier, 100).newTransaction();
            try {
                for (AbortRequest request : abortRequests) {
                    this.eslProcessing.processAbortRequest(request, (Transaction)transaction);
                }
                transaction.commit();
            }
            catch (Exception exc) {
                transaction.rollback();
                throw exc;
            }
        }
    }

    public void scheduleAbortRequest(AbortRequest abortRequest) {
        this.scheduledAbortRequests.offer(abortRequest);
    }
}

