/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.server;

import at.mrdevelopment.esl.configuration.Config;
import at.mrdevelopment.esl.template.DefaultImageRenderingEngine;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.log.ESLLogger;
import com.imagotag.rendering.ImageRenderingEngine;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

public class RenderingEngineInstanceFactory {
    static ESLLogger logger = ESLLogger.getLogger(RenderingEngineInstanceFactory.class);
    private final ClassLoader classLoader;
    private final String renderingEngineClassName;
    private ImageRenderingEngine renderingEngine;

    public RenderingEngineInstanceFactory(ClassLoader classLoader, String renderingEngineClassName) throws InitializationException {
        this.classLoader = classLoader;
        this.renderingEngineClassName = renderingEngineClassName;
    }

    private ImageRenderingEngine loadRenderingEngine(ClassLoader classLoader, String renderingEngineClassName) throws InitializationException {
        if (renderingEngineClassName == null) {
            logger.debug("Using default image rendering engine");
            return new DefaultImageRenderingEngine(Config.isUseSecureTemplateProcessing());
        }
        try {
            logger.debug("Loading custom rendering engine");
            Class<?> renderingClass = Class.forName(renderingEngineClassName, true, classLoader);
            Constructor<?> constructor = renderingClass.getConstructor(new Class[0]);
            return (ImageRenderingEngine)ImageRenderingEngine.class.cast(constructor.newInstance(new Object[0]));
        }
        catch (ClassCastException exc) {
            throw new InitializationException((Throwable)exc);
        }
        catch (InstantiationException exc) {
            throw new InitializationException((Throwable)exc);
        }
        catch (IllegalAccessException exc) {
            throw new InitializationException((Throwable)exc);
        }
        catch (ClassNotFoundException exc) {
            throw new InitializationException((Throwable)exc);
        }
        catch (IllegalArgumentException exc) {
            throw new InitializationException((Throwable)exc);
        }
        catch (InvocationTargetException exc) {
            throw new InitializationException((Throwable)exc);
        }
        catch (SecurityException exc) {
            throw new InitializationException((Throwable)exc);
        }
        catch (NoSuchMethodException exc) {
            throw new InitializationException((Throwable)exc);
        }
    }

    public ImageRenderingEngine getRenderingEngine() throws InitializationException {
        if (this.renderingEngine == null) {
            this.renderingEngine = this.loadRenderingEngine(this.classLoader, this.renderingEngineClassName);
            logger.info("Loaded image rendering engine: %s, %s", new Object[]{this.renderingEngine.getName(), this.renderingEngine.getVersion()});
        }
        return this.renderingEngine;
    }
}

