/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.server;

import at.mrdevelopment.esl.core.LabelId;
import at.mrdevelopment.esl.persistence.DatasetException;
import at.mrdevelopment.esl.persistence.dataset.LabelInfoHistoryDataset;
import at.mrdevelopment.esl.persistence.dataset.Transaction;
import at.mrdevelopment.esl.persistence.record.Commitable;
import at.mrdevelopment.esl.persistence.record.LabelInfo;
import at.mrdevelopment.esl.persistence.record.LabelInfoHistoryRecord;
import at.mrdevelopment.toolkit.authentication.UserId;
import at.mrdevelopment.toolkit.log.ESLLogger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class PersistLabelInfoCache {
    static ESLLogger logger = ESLLogger.getLogger(PersistLabelInfoCache.class);
    private LabelInfoHistoryDataset labelInfoHistoryDataset;
    private Map<LabelId, LabelInfo> labelInfosToPersist = new HashMap<LabelId, LabelInfo>();

    public PersistLabelInfoCache(LabelInfoHistoryDataset labelInfoHistoryDataset) {
        this.labelInfoHistoryDataset = labelInfoHistoryDataset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToCache(LabelInfo labelInfo) {
        Map<LabelId, LabelInfo> map = this.labelInfosToPersist;
        synchronized (map) {
            this.labelInfosToPersist.put(labelInfo.getLabelId(), labelInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCache() {
        Map<LabelId, LabelInfo> map = this.labelInfosToPersist;
        synchronized (map) {
            if (this.labelInfosToPersist.size() > 0) {
                this.labelInfosToPersist.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void persistInfos(Transaction<?> transaction) throws Exception {
        ArrayList<LabelInfo> labelInfos = null;
        Map<LabelId, LabelInfo> map = this.labelInfosToPersist;
        synchronized (map) {
            labelInfos = new ArrayList<LabelInfo>(this.labelInfosToPersist.values());
            this.clearCache();
        }
        logger.debug("Persisting %d label info records", new Object[]{labelInfos.size()});
        Iterator iterator = labelInfos.iterator();
        block7: while (true) {
            try {
                while (iterator.hasNext()) {
                    LabelInfo labelInfo = (LabelInfo)iterator.next();
                    try {
                        this.labelInfoHistoryDataset.store((Commitable)new LabelInfoHistoryRecord(labelInfo), UserId.SYSTEM, transaction);
                        iterator.remove();
                        continue block7;
                    }
                    catch (DatasetException exc) {
                        logger.logException((Throwable)exc);
                        logger.warn("Could not persist label history entry: %s", new Object[]{exc.getMessage()});
                        logger.logExceptionIfDebugEnabled((Throwable)exc);
                    }
                }
                break;
            }
            catch (Exception exc) {
                transaction.rollback();
                throw exc;
            }
        }
    }
}

