/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.server;

import at.mrdevelopment.esl.type.WakeupStatistic;
import at.mrdevelopment.esl.wireless.Address;
import at.mrdevelopment.toolkit.log.ESLLogger;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class MultipleWakeupStatistic
implements Comparable<MultipleWakeupStatistic> {
    static ESLLogger logger = ESLLogger.getLogger(MultipleWakeupStatistic.class);
    private final Address labelAddress;
    private final Map<Integer, WakeupStatistic> wakeupStatistics = new HashMap<Integer, WakeupStatistic>();

    public MultipleWakeupStatistic(Address labelAddress) {
        this.labelAddress = labelAddress;
    }

    public Address getLabelAddress() {
        return this.labelAddress;
    }

    public boolean addWakeupStatistic(WakeupStatistic newWakeupStatistic) {
        WakeupStatistic wakeupStatistic = this.wakeupStatistics.get(newWakeupStatistic.getAccessPointId());
        if (wakeupStatistic == null) {
            this.wakeupStatistics.put(newWakeupStatistic.getAccessPointId(), newWakeupStatistic);
            return true;
        }
        if (!wakeupStatistic.equals((Object)newWakeupStatistic)) {
            this.wakeupStatistics.put(newWakeupStatistic.getAccessPointId(), newWakeupStatistic);
            return true;
        }
        return false;
    }

    public WakeupStatistic getForAccessPoint(int accessPointId) {
        return this.wakeupStatistics.get(accessPointId);
    }

    public Collection<WakeupStatistic> getWakeupStatistics() {
        return this.wakeupStatistics.values();
    }

    @Override
    public int compareTo(MultipleWakeupStatistic other) {
        return this.labelAddress.compareTo(other.getLabelAddress());
    }
}

