/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.server;

import at.mrdevelopment.esl.admin.platform.config.storage.PlatformStorage;
import at.mrdevelopment.esl.custom.ConnectorInformationProvider;
import at.mrdevelopment.esl.custom.ServerStartupSettings;
import at.mrdevelopment.esl.custom.impl.Level1Implementation;
import at.mrdevelopment.esl.custom.level1.Level1Connector;
import at.mrdevelopment.esl.custom.level1.Level1Interface;
import at.mrdevelopment.esl.persistence.DatasetException;
import at.mrdevelopment.esl.persistence.dataset.Dataset;
import at.mrdevelopment.esl.persistence.maintenance.migration.DatabaseMigrationTask;
import at.mrdevelopment.esl.persistence.maintenance.migration.DropFKMigrationTask;
import at.mrdevelopment.esl.persistence.maintenance.migration.DropTableMigrationTask;
import at.mrdevelopment.esl.persistence.maintenance.migration.SimpleDatabaseMigrationTask;
import at.mrdevelopment.esl.persistence.record.AccessPointConfiguration;
import at.mrdevelopment.esl.persistence.record.AccessPointUpdateRecord;
import at.mrdevelopment.esl.persistence.record.BatteryReplacementRecord;
import at.mrdevelopment.esl.persistence.record.Configuration;
import at.mrdevelopment.esl.persistence.record.DatabaseIdentifier;
import at.mrdevelopment.esl.persistence.record.LabelActivePage;
import at.mrdevelopment.esl.persistence.record.LabelDetail;
import at.mrdevelopment.esl.persistence.record.LabelEventRecord;
import at.mrdevelopment.esl.persistence.record.LabelInfoHistoryRecord;
import at.mrdevelopment.esl.persistence.record.LabelPageContent;
import at.mrdevelopment.esl.persistence.record.LicenceRecord;
import at.mrdevelopment.esl.persistence.record.RegisteredLabel;
import at.mrdevelopment.esl.persistence.record.TaskRecord;
import at.mrdevelopment.esl.persistence.record.TransactionRecord;
import at.mrdevelopment.esl.persistence.record.UpdateImage;
import at.mrdevelopment.esl.persistence.record.UpdateStatus;
import at.mrdevelopment.esl.persistence.record.User;
import at.mrdevelopment.esl.server.ConnectorInstanceFactory;
import at.mrdevelopment.esl.server.DatasetInstanceFactory;
import at.mrdevelopment.esl.server.ESLServer;
import at.mrdevelopment.esl.server.RenderingEngineInstanceFactory;
import at.mrdevelopment.esl.server.data.DataExporter;
import at.mrdevelopment.esl.server.data.DataImporter;
import at.mrdevelopment.esl.server.data.DatabaseIdImporter;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.http.WebserviceException;
import at.mrdevelopment.toolkit.log.ESLLogger;
import at.mrdevelopment.toolkit.xml.SerializeException;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import org.hibernate.SessionFactory;

public class Level1Server
extends ESLServer
implements ConnectorInformationProvider {
    static ESLLogger logger = ESLLogger.getLogger(Level1Server.class);
    protected Level1Implementation level1;
    private ConnectorInstanceFactory<Level1Connector, Level1Interface> level1ConnectorsFactory;
    private Collection<String> level1ConnectorClassNames;
    private final boolean useSSL;

    public Level1Server(File databaseConfigFile, ServerStartupSettings serverStartupSettings, ClassLoader classLoader, PlatformStorage platformStorage, boolean useSSL) throws InitializationException, SerializeException, DatasetException {
        super(databaseConfigFile, serverStartupSettings, classLoader, platformStorage);
        this.useSSL = useSSL;
        this.loadConnectorClasses();
        SessionFactory sessionFactory = this.initSessionFactory();
        this.executeMigrations(sessionFactory);
        this.loadImplementation(sessionFactory);
    }

    protected void loadConnectorClasses() throws InitializationException {
        this.level1ConnectorClassNames = this.serverStartupSettings.getConnectorConfiguration().loadConnectorClassNames(this.classLoader, Level1Connector.class);
        Collection<Class<?>> recordClasses = this.serverStartupSettings.getConnectorConfiguration().loadRecordClasses(this.classLoader);
        for (Class<?> recordClass : recordClasses) {
            this.configuration.addAnnotatedClass(recordClass);
        }
        this.level1ConnectorsFactory = new ConnectorInstanceFactory(this.classLoader, this.level1ConnectorClassNames, Level1Connector.class);
    }

    protected void loadImplementation(SessionFactory sessionFactory) throws DatasetException, InitializationException, SerializeException {
        this.level1 = this.loadLevel1(sessionFactory);
        Collection<Dataset<?>> datasets = new DatasetInstanceFactory(this.classLoader, this.serverStartupSettings.getConnectorConfiguration()).getDatasets();
        Iterator<Dataset<?>> i$ = datasets.iterator();
        while (i$.hasNext()) {
            Dataset<?> dataset;
            Dataset<?> castedDataset = dataset = i$.next();
            this.level1.registerDataset(castedDataset.getRecordClass(), castedDataset);
        }
    }

    private Level1Implementation loadLevel1(SessionFactory sessionFactory) throws InitializationException, SerializeException, DatasetException {
        try {
            DatabaseIdImporter databaseIdImporter = new DatabaseIdImporter(this.classLoader, this.platformStorage);
            databaseIdImporter.importData(this.serverStartupSettings.getImportFile());
            this.serverStartupSettings.setDatabaseId(databaseIdImporter.getDatabaseId());
        }
        catch (Exception exc) {
            throw new InitializationException((Throwable)exc);
        }
        RenderingEngineInstanceFactory renderingEngineInstanceFactory = new RenderingEngineInstanceFactory(this.classLoader, this.serverStartupSettings.getConnectorConfiguration().loadRenderingEngineClassName(this.classLoader));
        Level1Implementation level1 = new Level1Implementation(this, this.info.getVersion(), this.datasetRegistry, sessionFactory, this.serverStartupSettings, renderingEngineInstanceFactory, this.useSSL);
        this.level1ConnectorsFactory.loadConnectors(this.classLoader, this.level1ConnectorClassNames, Level1Connector.class, Level1Interface.class, level1);
        Collection<Level1Connector> level1Connectors = this.level1ConnectorsFactory.getConnectors();
        for (Level1Connector connector : level1Connectors) {
            level1.registerConnector(connector);
        }
        level1.setDataImporter((DataImporter)this.level1ConnectorsFactory.loadDataMigrationInstance(this.classLoader, this.platformStorage, Level1Interface.class, level1, "at.mrdevelopment.esl.custom.export.Level1Importer"));
        level1.setDataExporter((DataExporter)this.level1ConnectorsFactory.loadDataMigrationInstance(this.classLoader, this.platformStorage, Level1Interface.class, level1, "at.mrdevelopment.esl.custom.export.Level1Exporter"));
        return level1;
    }

    public Collection<Level1Connector> getLevel1Connectors() {
        return this.level1ConnectorsFactory.getConnectors();
    }

    public void exportData(File exportFile) throws Exception {
        this.level1.getDataExporter().exportData(exportFile);
    }

    public void importData(File importFile) throws Exception {
        this.level1.getDataImporter().importData(importFile);
    }

    @Override
    protected void addRecordTypes(org.hibernate.cfg.Configuration configuration) {
        Level1Server.addDefaultRecordTypes(configuration);
    }

    public static void addDefaultRecordTypes(org.hibernate.cfg.Configuration configuration) {
        configuration.addAnnotatedClass(User.class);
        configuration.addAnnotatedClass(Configuration.class);
        configuration.addAnnotatedClass(AccessPointConfiguration.class);
        configuration.addAnnotatedClass(LicenceRecord.class);
        configuration.addAnnotatedClass(RegisteredLabel.class);
        configuration.addAnnotatedClass(TransactionRecord.class);
        configuration.addAnnotatedClass(TaskRecord.class);
        configuration.addAnnotatedClass(UpdateStatus.class);
        configuration.addAnnotatedClass(UpdateImage.class);
        configuration.addAnnotatedClass(LabelDetail.class);
        configuration.addAnnotatedClass(LabelInfoHistoryRecord.class);
        configuration.addAnnotatedClass(DatabaseIdentifier.class);
        configuration.addAnnotatedClass(LabelPageContent.class);
        configuration.addAnnotatedClass(LabelActivePage.class);
        configuration.addAnnotatedClass(AccessPointUpdateRecord.class);
        configuration.addAnnotatedClass(BatteryReplacementRecord.class);
        configuration.addAnnotatedClass(LabelEventRecord.class);
    }

    @Override
    public void start(int listenPort, boolean ssl) throws InitializationException, WebserviceException {
        this.level1.start(listenPort, ssl);
    }

    public void startJerseyServer(int defaultWebservicePort, boolean ssl) throws InitializationException, WebserviceException {
        this.level1.startJerseyServer(defaultWebservicePort, ssl);
    }

    @Override
    public Collection<Class<? extends Level1Connector>> getActivatedConnectors() {
        return this.level1 != null ? this.getActivatedConnectors(this.level1.getConnectors()) : new ArrayList<Class<? extends Level1Connector>>();
    }

    protected Collection<Class<? extends Level1Connector>> getActivatedConnectors(Set<? extends Level1Connector> connectors) {
        ArrayList<Class<? extends Level1Connector>> connectorClasses = new ArrayList<Class<? extends Level1Connector>>();
        for (Level1Connector level1Connector : connectors) {
            connectorClasses.add(level1Connector.getClass());
        }
        return connectorClasses;
    }

    private void executeMigrations(SessionFactory sessionFactory) {
        logger.info("Applying migrations...");
        ArrayList<SimpleDatabaseMigrationTask> migrationTasks = new ArrayList<SimpleDatabaseMigrationTask>();
        migrationTasks.add(new DropFKMigrationTask("FK1CD2B55D36F26B04", "ESL_TRANSACTION"));
        migrationTasks.add(new DropFKMigrationTask("FK7B321FB636F26B04", "ESL_LABEL_DATA"));
        migrationTasks.add(new DropFKMigrationTask("FK7B321FB643B49D35", "ESL_LABEL_DATA"));
        migrationTasks.add(new DropFKMigrationTask("FKAD6883C636F26B04", "ESL_TASK"));
        migrationTasks.add(new DropFKMigrationTask("FKAD6883C647BEBD3B", "ESL_TASK"));
        migrationTasks.add(new DropFKMigrationTask("FKE01CA3FF36F26B04", "ESL_UPDATE_HISTORY"));
        migrationTasks.add(new DropFKMigrationTask("FKE01CA3FF43B49D35", "ESL_UPDATE_HISTORY"));
        migrationTasks.add(new DropFKMigrationTask("FKAD6883C68DA066C1", "ESL_TASK"));
        migrationTasks.add(new DropFKMigrationTask("FK3FB451EF36F26B04", "ESL_LABEL_INFO_HISTORY"));
        migrationTasks.add(new DropFKMigrationTask("FK11072EB547BEBD3B", "ESL_LABEL_PAGE_CONTENT"));
        migrationTasks.add(new DropTableMigrationTask("ESL_LABEL_DATA"));
        for (DatabaseMigrationTask databaseMigrationTask : migrationTasks) {
            databaseMigrationTask.makeMigration(sessionFactory);
        }
        logger.info("Migration finished");
    }

    public void shutdownService() {
        this.level1.shutdownService();
    }
}

