/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.server;

import at.mrdevelopment.esl.core.LabelEvent;
import at.mrdevelopment.esl.custom.impl.Level1Implementation;
import at.mrdevelopment.esl.custom.level1.Level1Connector;
import at.mrdevelopment.esl.persistence.DatasetException;
import at.mrdevelopment.esl.persistence.dataset.LabelEventDataset;
import at.mrdevelopment.esl.persistence.dataset.Transaction;
import at.mrdevelopment.esl.persistence.query.DatasetQuery;
import at.mrdevelopment.esl.persistence.query.QueryRestriction;
import at.mrdevelopment.esl.persistence.query.QueryResult;
import at.mrdevelopment.esl.persistence.record.Commitable;
import at.mrdevelopment.esl.persistence.record.LabelEventRecord;
import at.mrdevelopment.toolkit.authentication.UserId;
import at.mrdevelopment.toolkit.log.ESLLogger;
import java.util.List;

public class LabelEventService {
    static ESLLogger logger = ESLLogger.getLogger(LabelEventService.class);
    private final Level1Implementation level1;
    private final LabelEventDataset labelEventDataset;

    public LabelEventService(Level1Implementation level1, LabelEventDataset labelEventDataset) {
        this.level1 = level1;
        this.labelEventDataset = labelEventDataset;
    }

    public void handleLabelEvent(LabelEvent labelEvent) throws DatasetException {
        Transaction transaction = this.level1.getTransactionSupplier().newTransaction();
        try {
            boolean modified = this.handleLabelEvent(labelEvent, transaction);
            transaction.commit();
            if (modified) {
                for (Level1Connector connector : this.level1.getConnectors()) {
                    connector.notifyLabelEvent(labelEvent);
                }
            }
        }
        catch (Exception exc) {
            transaction.rollback();
            throw new DatasetException((Throwable)exc);
        }
    }

    private boolean handleLabelEvent(LabelEvent labelEvent, Transaction<?> transaction) throws DatasetException {
        LabelEventRecord labelEventRecord;
        DatasetQuery query = this.level1.getQuery("labelevent/id");
        QueryResult result = query.getResult(QueryRestriction.newUnpagedSearchQuery(String.class, (Object)labelEvent.getEventId().toString()), transaction);
        if (result == null || result.getTotalRecords() == 0) {
            this.labelEventDataset.store((Commitable)new LabelEventRecord(labelEvent), UserId.SYSTEM, transaction);
            return true;
        }
        List records = result.getRecords();
        if (!records.isEmpty() && LabelEventRecord.toLabelEvent((LabelEventRecord)(labelEventRecord = (LabelEventRecord)records.get(0))).isDifferentFrom(labelEvent)) {
            labelEventRecord.updateWith(labelEvent);
            this.labelEventDataset.store((Commitable)labelEventRecord, UserId.SYSTEM, transaction);
            return true;
        }
        return false;
    }
}

