/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.server;

import at.mrdevelopment.esl.configuration.ConfigurationChangedListener;
import at.mrdevelopment.esl.core.ESLProcessing;
import at.mrdevelopment.esl.core.ESLProcessingTask;
import at.mrdevelopment.esl.core.ESLService;
import at.mrdevelopment.esl.core.LabelId;
import at.mrdevelopment.esl.core.ServiceStatus;
import at.mrdevelopment.esl.core.UpdateResultListener;
import at.mrdevelopment.esl.core.problem.ProblemStatus;
import at.mrdevelopment.esl.core.security.Pin;
import at.mrdevelopment.esl.network.NetworkStatus;
import at.mrdevelopment.esl.network.NetworkStatusGenerator;
import at.mrdevelopment.esl.persistence.dataset.Transaction;
import at.mrdevelopment.esl.persistence.dataset.TransactionSupplier;
import at.mrdevelopment.esl.persistence.record.Commitable;
import at.mrdevelopment.esl.server.DiskStateListener;
import at.mrdevelopment.esl.server.ServerMSPStatusTask;
import at.mrdevelopment.esl.server.ServiceStatusGenerator;
import at.mrdevelopment.esl.tasks.AbortRequest;
import at.mrdevelopment.esl.tasks.RegisterLabelTask;
import at.mrdevelopment.esl.tasks.Task;
import at.mrdevelopment.esl.tasks.UnregisterLabelTask;
import at.mrdevelopment.esl.type.TaskTransaction;
import at.mrdevelopment.esl.type.UpdateResult;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.appliance.disk.DiskState;
import at.mrdevelopment.toolkit.authentication.UserId;
import at.mrdevelopment.toolkit.log.ESLLogger;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ESLServiceImpl
implements ESLService,
UpdateResultListener,
ConfigurationChangedListener,
DiskStateListener {
    static ESLLogger logger = ESLLogger.getLogger(ESLServiceImpl.class);
    private final ESLProcessing processing;
    private final ServiceStatusGenerator serviceStatusGenerator;
    private final NetworkStatusGenerator networkStatusGenerator;
    private final TransactionSupplier transactionSupplier;
    private final Set<UpdateResultListener> updateResultListeners = new HashSet<UpdateResultListener>();

    public ESLServiceImpl(ESLProcessing processing, TransactionSupplier transactionSupplier, ServiceStatusGenerator serviceStatusGenerator, NetworkStatusGenerator networkStatusGenerator) throws InitializationException {
        this.processing = processing;
        this.transactionSupplier = transactionSupplier;
        this.serviceStatusGenerator = serviceStatusGenerator;
        this.networkStatusGenerator = networkStatusGenerator;
        this.createProcessingTasks();
    }

    private void createProcessingTasks() throws InitializationException {
        this.processing.addProcessingTask((ESLProcessingTask)new ServerMSPStatusTask(this));
        this.processing.addProcessingTask(new ESLProcessingTask(){

            public void run() throws Exception {
                logger.info("Updating service status");
                this.updateServiceStatus();
                logger.info("Updating network status");
                this.updateNetworkStatus();
            }

            private void updateServiceStatus() throws Exception {
                Transaction transaction = ESLServiceImpl.this.transactionSupplier.newTransaction();
                try {
                    ESLServiceImpl.this.serviceStatusGenerator.updateServiceStatus(transaction);
                    transaction.commit();
                }
                catch (Exception exc) {
                    transaction.rollback();
                    throw exc;
                }
            }

            private void updateNetworkStatus() {
                try {
                    ESLServiceImpl.this.networkStatusGenerator.updateNetworkStatus();
                }
                catch (InitializationException exc) {
                    logger.warn("Unable to retrieve network status: %s", new Object[]{exc.getMessage()});
                    logger.logExceptionIfDebugEnabled((Throwable)exc);
                }
            }
        });
    }

    public void registerProblemStatus(ProblemStatus problemStatus) {
        this.serviceStatusGenerator.registerProblemStatus(problemStatus);
    }

    public void registerRecordClass(Class<? extends Commitable> recordClass, List<String> customFields) {
        this.serviceStatusGenerator.registerRecordClass(recordClass, customFields);
    }

    public void addTask(TaskTransaction transaction, Task task) {
        logger.debug("Adding %s to label %s to scheduled tasks queue", new Object[]{task.getClass().getSimpleName(), task.getLabelId()});
        this.processing.scheduleTask(transaction, task);
    }

    public void abort(AbortRequest abortRequest) {
        this.processing.scheduleAbortRequest(abortRequest);
    }

    public ServiceStatus getServiceStatus(UserId user) {
        return this.serviceStatusGenerator.getServiceStatus(user);
    }

    public NetworkStatus getNetworkStatus() {
        return this.networkStatusGenerator.getNetworkStatus();
    }

    public void registerLabel(TaskTransaction transaction, LabelId labelId, Pin pin, Set<String> tags, long externalId) {
        RegisterLabelTask registerTask = new RegisterLabelTask(labelId, pin, tags, externalId, false);
        this.processing.scheduleTask(transaction, (Task)registerTask);
    }

    public void unregisterLabel(TaskTransaction transaction, LabelId labelId, long externalId) {
        UnregisterLabelTask registerTask = new UnregisterLabelTask(labelId, externalId, false);
        this.processing.scheduleTask(transaction, (Task)registerTask);
    }

    public void shutdown() {
        logger.info("Shutdown ESL service");
        this.processing.shutdown();
    }

    public void registerUpdateResultListener(UpdateResultListener listener) {
        this.updateResultListeners.add(listener);
    }

    public void unregisterUpdateResultListener(UpdateResultListener listener) {
        this.updateResultListeners.remove(listener);
    }

    public void updateFinished(UpdateResult updateResult) {
        for (UpdateResultListener listener : this.updateResultListeners) {
            listener.updateFinished(updateResult);
        }
    }

    @Override
    public void configurationChanged(String key, String value, Transaction<?> transaction) throws Exception {
        this.serviceStatusGenerator.updateServiceStatus(transaction);
    }

    @Override
    public void notifyDiskStateUpdated(DiskState diskState) {
        this.serviceStatusGenerator.notifyDiskStateUpdated(diskState);
    }
}

